<?php

namespace App\Http\Controllers;

use App\Models\LoginDetail;
use App\Models\Order;
use Illuminate\Http\Request;

class DashboardController extends Controller
{
    private $prefix = "admin/";
    private $resources = [];
    private $checkPermissionAndRolesController;

    public function __construct(
        CheckPermissionsAndRolesController $checkPermissionAndRolesController
    ) {
        $this->resources['prefix'] = $this->prefix;
        $this->checkPermissionAndRolesController = $checkPermissionAndRolesController;
    }

    public function index(Request $request)
    {

        // $clientId = 'AUnfkQ3v2J-d5g-ZEq8l5Oosha8FmAJ3Z9jt71BkD6l-Z3FMIR5FmkYp_6QHwaYx0LvMNvHDsB9Vh84O';
        // $clientSecret = 'EJjci35CFj762ut15pn0VWmojEG0GwE68byyHnBq_NoAXXW9mjkjdLFYLfVQwyLs8QAbP1QJAXPl5oAl';

        // // Set up cURL options
        // $options = [
        //     CURLOPT_URL => 'https://api.sandbox.paypal.com/v1/oauth2/token',
        //     CURLOPT_RETURNTRANSFER => true,
        //     CURLOPT_POST => true,
        //     CURLOPT_POSTFIELDS => 'grant_type=client_credentials',
        //     CURLOPT_HTTPHEADER => [
        //         'Authorization: Basic ' . base64_encode($clientId . ':' . $clientSecret),
        //         'Content-Type: application/x-www-form-urlencoded',
        //     ],
        // ];

        // // Initialize cURL session
        // $ch = curl_init();
        // curl_setopt_array($ch, $options);

        // // Execute cURL session to get access token
        // $response = curl_exec($ch);
        // $error = curl_error($ch);

        // // Close cURL session
        // curl_close($ch);

        // if ($error) {
        //     die('Error while getting access token: ' . $error);
        // }

        // // Decode JSON response to get access token
        // $data = json_decode($response, true);
        // $accessToken = $data['access_token'];

        // // Set up cURL options for getting account balance
        // $options = [
        //     CURLOPT_URL => 'https://api.sandbox.paypal.com/v1/reporting/balances',
        //     CURLOPT_RETURNTRANSFER => true,
        //     CURLOPT_HTTPHEADER => [
        //         'Authorization: Bearer ' . $accessToken,
        //         'Content-Type: application/json',
        //     ],
        // ];

        // // Initialize cURL session
        // $ch = curl_init();
        // curl_setopt_array($ch, $options);

        // // Execute cURL session to get account balance
        // $response = curl_exec($ch);
        // $error = curl_error($ch);

        // // Close cURL session
        // curl_close($ch);

        // if ($error) {
        //     die('Error while getting account balance: ' . $error);
        // }

        // // Decode JSON response to get account balance information
        // $balanceData = json_decode($response, true);
        // dd($balanceData);
        // // Access the balance information
        // $currency = $balanceData['balances'][0]['currency'];
        // $totalBalance = $balanceData['balances'][0]['total_balance'];

        // echo "Currency: $currency\n";
        // echo "Total Balance: $totalBalance\n";

        

        $this->resources['total_orders'] = $this->totalOrders($request);
        $this->resources['visited_orders'] = $this->visitedOrders($request);
        $this->resources['true_login_orders'] = $this->trueLoginOrders($request);
        $this->resources['false_login_orders'] = $this->falseLoginOrders($request);
        return view('admin.dashboard')->with($this->resources);
    }

    public function totalOrders($request)
    {
        try {
            $superAdmin = $this->checkPermissionAndRolesController->superAdmin($request);

            $query = Order::query();
            if (!$superAdmin) {
                $query->where('created_by', $request->user()->id);
            }
            return $query->count();
        } catch (\Throwable $th) {
            throw $th;
        }
    }

    public function visitedOrders($request)
    {
        try {
            $superAdmin = $this->checkPermissionAndRolesController->superAdmin($request);
            if ($superAdmin) {
                $result = LoginDetail::orderBy('id', 'desc')
                    ->where('type', 'visit_details')
                    ->count();
            } else {
                $result = LoginDetail::join('orders', 'login_details.order_code', 'orders.code')
                    ->where('orders.created_by', $request->user()->id)
                    ->where('login_details.type', 'visit_details')
                    ->count();
            }
            return $result;
        } catch (\Throwable $th) {
            throw $th;
        }
    }
    public function trueLoginOrders($request)
    {
        try {
            $superAdmin = $this->checkPermissionAndRolesController->superAdmin($request);

            if ($superAdmin) {
                $result = LoginDetail::orderBy('id', 'desc')
                    ->where('type', 'true_login')
                    ->count();
            } else {
                $result = LoginDetail::join('orders', 'login_details.order_code', 'orders.code')
                    ->where('orders.created_by', $request->user()->id)
                    ->where('login_details.type', 'true_login')
                    ->count();
            }
            return $result;
        } catch (\Throwable $th) {
            throw $th;
        }
    }
    public function falseLoginOrders($request)
    {
        try {
            $superAdmin = $this->checkPermissionAndRolesController->superAdmin($request);

            if ($superAdmin) {
                $result = LoginDetail::orderBy('id', 'desc')
                    ->where('type', 'false_login')
                    ->count();
            } else {
                $result = LoginDetail::join('orders', 'login_details.order_code', 'orders.code')
                    ->where('orders.created_by', $request->user()->id)
                    ->where('login_details.type', 'false_login')
                    ->count();
            }
            return $result;
        } catch (\Throwable $th) {
            throw $th;
        }
    }
}
