<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

class FmiCheckerController extends Controller
{
    private $prefix = "admin/fmi-checker/";
    private $resources = [];
    private $checkPermissionAndRolesController;

    function __construct(
        CheckPermissionsAndRolesController $checkPermissionAndRolesController
    ) {
        $this->resources['prefix'] = $this->prefix;
        $this->checkPermissionAndRolesController = $checkPermissionAndRolesController;
    }

    public function index(Request $request)
    {
        $this->checkPermissionAndRolesController->permissionTo($request, ['permission' => 'FMI Checker']);
        return view('admin.fmi-checker.index')->with($this->resources);
    }
    public function check(Request $request)
    {
        $credentials = $request->validate([
            'imei' => ['required'],
        ]);
        try {
            $requestAll = $request->all();
            if ($requestAll['imei'] && $requestAll['imei'] != "") {
                $imei_arr = explode("\r\n", $requestAll['imei']);
                $response_arr = [];
                foreach ($imei_arr as $value) {
                    $data = $this->sendReq($value);
                    if($data){
                        $response_arr[] = $data;
                    }else{
                        $response_arr[] = "<strong>IMEI: $value<br><span style='color:red'>NOT FOUND</strong>";
                    }
                }
            }
            $this->resources['data'] = $response_arr;
            return view('admin.fmi-checker.index')->with($this->resources);
        } catch (\Throwable $th) {
            $this->resources['messages'] = array("type" => "error", "description" => $th->getMessage());
            return redirect()->back()->with('messages', $this->resources);
        }
    }
    public function sendReq($im)
    {
        try {
            $url = "https://passcodefmi.com/MyFone/FMINew.php?imei=$im";
            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL, $url);
            // curl_setopt ($ch, CURLOPT_HEADER, 1);
            // curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
            curl_setopt($ch, CURLOPT_USERAGENT, 'Mozilla/5.0 (Windows; U; Windows NT 5.1; en-US; rv:1.8.1.13) Gecko/20080311 Firefox/2.0.0.13');
            curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 0);
            curl_setopt($ch, CURLOPT_TIMEOUT, 400);
            curl_setopt($ch, CURLOPT_FOLLOWLOCATION, 0);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
            curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
            // curl_setopt($ch, CURLOPT_COOKIE, $cookie);
            curl_setopt($ch, CURLOPT_REFERER, $url);
            $res = curl_exec($ch);
            $info = curl_getinfo($ch);
            curl_close($ch);
            if($info['http_code'] == 200){
                return $res;
            }
            return false;
        } catch (\Throwable $th) {
            throw $th;
        }
    }
}
