<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use App\Models\Subscription;
use App\Models\User;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Session;

class LoginController extends Controller
{
    private $resources = [];
    private $prefix = 'admin/';
    private $userController;
    public function __construct(
        UserController $userController
    )
    {
        $this->userController = $userController;
        $this->resources['prefix'] = $this->prefix;
    }
    public function welcome(Request $request)
    {
        if (Auth::check())
        {
            return redirect('admin/dashboard')->with($this->resources);
        }

        return view('admin.welcome')->with($this->resources);
    }
    public function secretCode(Request $request)
    {
        if (Auth::check())
        {
            return redirect('admin/dashboard')->with($this->resources);
        }

        return view('admin.secret_code')->with($this->resources);
    }
    public function verifyCode(Request $request)
    {
        $request->validate([
            'secret_code' => ['required'],
        ]);

        // Get all active users with this secret code
        $user = User::where('secret_code', $request->secret_code)
                    ->where('status', 1)
                    ->first();

        if ($user) {
            // Store verification status in session
            Session::put('secret_code_verified', true);
            Session::put('secret_code_verified_at', now());
            
            // You can optionally track which code was used
            Session::put('secret_code_used', $request->secret_code);
            
            return redirect()->route('login')->with('success', 'Secret code verified successfully');
        }
        return back()->withErrors([
            'secret_code' => 'The provided secret code is invalid.',
        ])->withInput();
    }
    public function index(Request $request)
    {
        if (Auth::check())
        {
            return redirect('admin/dashboard')->with($this->resources);
        }

        return view('admin.login')->with($this->resources);
    }
    /**
     * Handle an authentication attempt.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function authenticate(Request $request)
    {
        $credentials = $request->validate([
            'email' => ['required', 'email'],
            'password' => ['required'],
        ]);
        $remember = $request->remember_me;

        if (User::where('email', $request->email)->exists() && !$this->userController->checkUserActive(['email' => $request->email]))
        {
            return back()->withErrors([
                'email' => 'You are blocked by admin.',
            ])->onlyInput('email');
        }
        $user = User::where('email', $request->email)->first();
        if ($user)
        {
            // if ($user->mobile_verified_at == null || $user->mobile_verified_at < Carbon::now()->subDays(30))
            // {
            //     // The mobile_verified_at is null or more than 30 days old
            //     $this->sendOtp($request, $user);
            //     return redirect('mobile-verification')->with($this->resources);
            // }
            // $ipAddress = request()->ip();
            // $userAgent = request()->header('User-Agent');

            // $isDifferentDevice = $user->last_login_ip !== $ipAddress || $user->last_login_user_agent !== $userAgent;
            // if ($isDifferentDevice)
            // {
            //     $this->sendOtp($request, $user);
            //     return redirect('mobile-verification')->with($this->resources);
            // }
            if (Auth::attempt($credentials, $remember))
            {
                $request->session()->regenerate();

                return redirect()->intended('admin/dashboard')->with($this->resources);
            }
        }

        // if(!$this->isSubscribed($request->email)){
        //     return redirect()->route('subscription-expired');
        // }

        return back()->withErrors([
            'email' => 'The provided credentials do not match our records.',
        ])->onlyInput('email');
    }
    // public function isSubscribed($email)
    // {
    //     try {
    //         $user = User::where('email', $email)->select('id')->first();
    //         if(isset($user['id'])){
    //             $subscription = Subscription::where('user', $user['id'])->first();
    //             $startDate = Carbon::parse($subscription['from']);
    //             $endDate = Carbon::parse($subscription['to']);

    //             // Calculate the difference in days
    //             $diffInHours = $startDate->diffInHours($endDate);
    //             dd($diffInHours);
    //             if($diffInHours > 0){
    //                 return true;
    //             }
    //         }
    //         return false;
    //     } catch (\Throwable $th) {
    //         throw $th;
    //     }
    // }
    /**
     * Log the user out of the application.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function signOut(Request $request)
    {
        Auth::logout();

        $request->session()->invalidate();

        $request->session()->regenerateToken();

        Session::forget(['secret_code_verified', 'secret_code_verified_at', 'secret_code_used']);

        return redirect('/');
    }
    public function mobileVerification(Request $request)
    {
        return view('admin.verify')->with($this->resources);
    }
    public function verify(Request $request)
    {
        $credentials = $request->validate([
            'otp' => ['required', 'min:6', 'max:6'],
        ]);
        if (Session::get('otp') === $request->otp)
        {

            $user = User::where('email', Session::get('email'))->first();
            $ipAddress = request()->ip();
            $userAgent = request()->header('User-Agent');

            User::where('id', $user->id)->update(['mobile_verified_at' => now(), 'last_login_ip' => $ipAddress, 'last_login_user_agent' => $userAgent]);

            Auth::loginUsingId($user->id);

            $request->session()->regenerate();

            return redirect()->intended('admin/dashboard')->with($this->resources);
        }
        else
        {
            return back()->withErrors([
                'otp' => 'The provided otp is not valid try again.',
            ])->onlyInput('otp');
        }

        return view('admin.login')->with($this->resources);
    }
    public function generateOtp($length = 6)
    {
        $otp = '';
        for ($i = 0; $i < $length; $i++)
        {
            $otp .= mt_rand(0, 9);
        }
        return $otp;
    }
    public function sendOtp($request, $user)
    {
        $otp = $this->generateOtp();
        User::where('email', $request->email)->update(['otp' => $otp, 'mobile_verified_at' => null, 'last_login_ip' => null, 'last_login_user_agent' => null]);
        sendTeligramMessage($user->teligram, "Here is your 6 digits OTP " . $otp);
        Session::put('email', $request->email);
        Session::put('otp', $otp);
    }
    public function resendOtp()
    {
        if (Session::get('email') && Session::get('email') != NULL)
        {
            $user = User::where('email', Session::get('email'))->first();
            $otp = $this->generateOtp();
            User::where('email', $user->email)->update(['otp' => $otp, 'mobile_verified_at' => null, 'last_login_ip' => null, 'last_login_user_agent' => null]);
            sendTeligramMessage($user->teligram, "Here is your 6 digits OTP " . $otp);
            Session::put('email', $user->email);
            Session::put('otp', $otp);
            $this->resources['messages'] = array("type" => "success", "description" => "Otp resent. check your teligram.");
            return redirect()->back()->with('messages', $this->resources);
        }
        else
        {
            return redirect('/')->with($this->resources);
        }
    }
}
