<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Spatie\Permission\Models\Permission;

class PermissionController extends Controller
{
    private $prefix = "admin/users/permissions/";
    private $resources = [];
    private $checkPermissionAndRolesController;

    public function __construct(CheckPermissionsAndRolesController $checkPermissionAndRolesController)
    {
        $this->resources['prefix'] = $this->prefix;
        $this->checkPermissionAndRolesController = $checkPermissionAndRolesController;
    }
    public function index(Request $request)
    {
        $this->checkPermissionAndRolesController->permissionTo($request, ['permission'=>'Manage Permission']);
        $this->resources['data'] = $this->getPermissions(15);
        return view('admin.users.permissions.permissions_manage')->with($this->resources);
    }
    public function search(Request $request)
    {
        try {
            $request->validate([
                'search' => ['required'],
            ]);
            $order = Permission::query();
            if ($request->search) {
                $order->where('name', 'Like', '%' . $request->search . '%');
            }
            $this->resources['data'] = $order->orderBy('id', 'DESC')->paginate(15);
            return view('admin.users.permissions.permissions_manage')->with($this->resources);
        } catch (\Throwable $th) {
            $this->resources['messages'] = array("type" => "error", "description" => $th->getMessage());
            return redirect()->back()->with('messages', $this->resources);
        }
    }
    public function addPermission(Request $request)
    {   
        $this->checkPermissionAndRolesController->permissionTo($request, ['permission'=>'Manage Permission']);
        return view('admin.users.permissions.permission_add')->with($this->resources);
    }
    public function getPermissions($count)
    {
        
        try{
            $result = Permission::orderBy('id','desc')->paginate($count);
            return $result;
        }catch(\Exception $e){
            throw $e;
        }
    }
    public function getAll()
    {
        try{
            $result = Permission::all();
            return $result;
        }catch(\Exception $e){
            throw $e;
        }
    }
    public function getPermissionById($id)
    {
        try{
            $result = Permission::where('id', $id)->first();
            return $result;
        }catch(\Exception $e){
            throw $e;
        }
    }
    public function store(Request $request)
    { 
        $this->checkPermissionAndRolesController->permissionTo($request, ['permission'=>'Manage Permission']);
        $credentials = $request->validate([
            'guard_name' => ['required'],
            'name' => ['required']
        ]);
        try {
            
            $requestParam = $request->except('_token');
            $permission = Permission::create($requestParam);
            $this->resources['messages'] = array("type" => "success", "description"=>"Permission creation success");
            return redirect()->back()->with('messages',$this->resources);
        } catch (\Throwable $th) {
            $this->resources['messages'] = array("type" => "error", "description"=>$th->getMessage());
            return redirect()->back()->with('messages',$this->resources);
        }
    }
    public function editPermission(Request $request)
    {   
        $this->checkPermissionAndRolesController->permissionTo($request, ['permission'=>'Manage Permission']);
        $this->resources['permission'] = $this->getPermissionById($request->id);
        return view('admin.users.permissions.permission_edit')->with($this->resources);
    }
    public function update(Request $request)
    { 
        $this->checkPermissionAndRolesController->permissionTo($request, ['permission'=>'Manage Permission']);
        $credentials = $request->validate([
            'guard_name' => ['required'],
            'name' => ['required']
        ]);
        try {
            
            $requestParam = $request->except('_token');
            $permission = Permission::where('id', $request->id)->update($requestParam);
            $this->resources['messages'] = array("type" => "success", "description"=>"Permission updated success");
            return redirect()->back()->with('messages',$this->resources);
        } catch (\Throwable $th) {
            $this->resources['messages'] = array("type" => "error", "description"=>$th->getMessage());
            return redirect()->back()->with('messages',$this->resources);
        }
    }

    public function delete(Request $request)
    {
        $this->checkPermissionAndRolesController->permissionTo($request, ['permission'=>'Manage Permission']);
        $request->validate([
            'id' => ['required'],   
        ]);
        try {
            $result = Permission::where('id', $request->id)->delete();
            $this->resources['messages'] = array("type" => "success", "description"=>"Permission deleted success");
            return redirect()->back()->with('messages',$this->resources);
        } catch (\Throwable $th) {
            $this->resources['messages'] = array("type" => "error", "description"=>$th->getMessage());
            return redirect()->back()->with('messages',$this->resources);
        }
        
    }

}
