<?php

namespace App\Http\Middleware;

use App\Models\Subscription;
use App\Models\User;
use Carbon\Carbon;
use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class CheckSubscription
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure(\Illuminate\Http\Request): (\Illuminate\Http\Response|\Illuminate\Http\RedirectResponse)  $next
     * @return \Illuminate\Http\Response|\Illuminate\Http\RedirectResponse
     */
    public function handle(Request $request, Closure $next)
    {
        try {
            $subscription = Subscription::where('user', $request->user()->id)->first();
            
            if (isset($subscription['from'])) {
                $startDate = Carbon::parse(now());
                $endDate = Carbon::parse($subscription['to']);

                // Calculate the difference in days
                $diffInHours = $startDate->diffInHours($endDate);
                if ($startDate < $endDate) {
                    return $next($request);
                }
            } else {
                $role = User::join('roles', 'users.type', 'roles.id')->select('roles.name as role_name')->where('users.id', $request->user()->id)->first();
                if ($role['role_name'] == 'Super Admin') {
                    return $next($request);
                }
            }


            Auth::logout();
            return redirect()->route('subscription-expired');
        } catch (\Throwable $th) {
            throw $th;
        }
    }
}
