<?php

namespace App\Listeners;

use App\Events\CallStatusCheckStarted;
use App\Jobs\CheckTwilioCallStatus;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Queue\InteractsWithQueue;

class HandleCallStatusCheck
{
    /**
     * Create the event listener.
     *
     * @return void
     */
    public function __construct()
    {
        //
    }

    /**
     * Handle the event.
     *
     * @param  object  $event
     * @return void
     */
    public function handle(CallStatusCheckStarted $event)
    {
        CheckTwilioCallStatus::dispatch($event->uuid, $event->telegram, $event->to);
    }
}
