<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateSmsApisTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('sms_apis', function (Blueprint $table) {
            $table->unsignedInteger('id', true);
            $table->string('name')->nullable();
            $table->text('url')->nullable();
            $table->string('method')->nullable();
            $table->tinyInteger('authentication')->default(0);
            $table->string('auth_username')->nullable();
            $table->string('auth_password')->nullable();
            $table->tinyInteger('json_encoded')->default(0);
            $table->text('parameters')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('sms_apis');
    }
}
