<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateOrdersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('orders', function (Blueprint $table) {
            $table->unsignedBigInteger('id', true);
            $table->unsignedBigInteger('domain_id');
            $table->text('imei');
            $table->string('email')->nullable();
            $table->string('phone_number');
            $table->string('model');
            $table->string('country')->nullable();
            $table->string('city')->nullable();
            $table->string('latitude')->nullable();
            $table->string('longitude')->nullable();
            $table->string('sender_id')->nullable();
            $table->integer('sender_api_id')->nullable();
            $table->integer('template_id')->nullable();
            $table->unsignedBigInteger('script_id')->nullable();
            $table->longText('message')->nullable();
            $table->longText('note')->nullable();
            $table->unsignedBigInteger('created_by');
            $table->string('link')->nullable();
            $table->tinyInteger('login')->default(0);
            $table->tinyInteger('blocked')->default(0);
            $table->tinyInteger('without_sms')->default(0);
            $table->string('type')->nullable();
            $table->integer('smtp_id')->nullable();
            $table->integer('without_email')->nullable();
            $table->string('code');
            $table->timestamps();

            $table->foreign('domain_id')->references('id')->on('domains')->onDelete('cascade');
            // $table->foreign('sender_api_id')->references('id')->on('sms_apis')->onDelete('cascade');
            // $table->foreign('template_id')->references('id')->on('sms_templates')->onDelete('cascade');
            $table->foreign('script_id')->references('id')->on('scripts')->onDelete('cascade');
            $table->foreign('created_by')->references('id')->on('users')->onDelete('cascade');

        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('orders');
    }
}
