<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateTwiliosTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('twilios', function (Blueprint $table) {
            $table->id();
            $table->string('to')->nullable();
            $table->string('from')->nullable();
            $table->integer('audio_id')->nullable();
            $table->string('uuid')->nullable();
            $table->string('status')->nullable();
            $table->string('direction')->nullable();
            $table->string('conversation_uuid')->nullable();
            $table->string('dtmf')->nullable();
            $table->json('data')->nullable();
            $table->integer('country')->nullable();
            $table->integer('created_by')->nullable();
            $table->bigInteger('from_number_id')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('twilios');
    }
}
