function swAjaxAlert(data) { 
    Swal.fire({
        position: 'top-end',
        icon: data.type,
        title: data.title,
        showConfirmButton: false,
        timer: 7000
    })
}
function ajax(data) {
    $.ajaxSetup({
        headers: {
            'X-CSRF-TOKEN': $('meta[name="_token"]').attr('content')
        }
    });
    var ajax = $.ajax({
        type: data.method,
        url: data.url,
        data: data.data,
        dataType: data.type,
        async: false,
        beforeSend:function (){
            $("#loader").show();
        },
        success: function (response) {
            $("#loader").hide();
        },
        error:function(xhr){
            $("#loader").hide();
            Swal.fire({
                position: 'top-end',
                icon: "error",
                title: xhr.responseJSON.message,
                showConfirmButton: false,
                timer: 7000
            })
        }
    });

    if(ajax.status == 200){
        return ajax.responseJSON;
    }else{
        swAjaxAlert({"type":"error", "title":ajax.responseText});
    }
    
}