@extends('components.app')
@section('styles')
@endsection
@section('title')
    Add Email Template
@endsection

@section('content')
    <!-- Begin Page Content -->
    <div class="container">

        <!-- Page Heading -->
        {{-- <div class="d-sm-flex align-items-center justify-content-between mb-4">
        <h1 class="h3 mb-0 text-gray-800">Add User</h1>
        
    </div> --}}
        <div class="d-flex align-items-center p-3 my-3 text-white bg-primary rounded shadow-sm">
            <svg class="bd-placeholder-img flex-shrink-0 me-2 rounded" width="32" height="32"
                xmlns="http://www.w3.org/2000/svg" role="img" aria-label="Placeholder: 32x32"
                preserveAspectRatio="xMidYMid slice" focusable="false">
                <title>Placeholder</title>
                <rect width="100%" height="100%" fill="var(--white)"></rect><text x="50%" y="50%"
                    fill="var(--white)" dy=".3em">32x32</text>
            </svg>

            <div class="ml-2">
                <h1 class="h6 mb-0 text-white lh-1">Add Email Template</h1>
                <small><a class="text-white" href="{{ url('admin/dashboard') }}">dashboard</a> > <a class="text-white"
                        href="{{ url($prefix . 'manage') }}">manage email template</a> > add new email template</small>
            </div>
        </div>
        <!-- Content Row -->
        <div class="row">
            <div class="col-sm-12">
                <div class="card mb-4 shadow">
                    <div class="card-body">
                        <form action="{{ url($prefix . 'store') }}" method="post">
                            @csrf
                            <div class="row">
                                <div class="col-sm-12">
                                    <div class="form-group">
                                        <label class="small">Name <span class="text-danger">*</span></label>
                                        <input type="text" class="form-control @error('name') is-invalid @enderror"
                                            value="{{ old('name') }}" name="name" aria-describedby="nameHelp"
                                            id="name" placeholder="Template Name" required>
                                        @error('name')
                                            <span class="text-danger small">{{ $message }}</span>
                                        @enderror
                                    </div>
                                    <div class="form-group">
                                        <label class="small">Template <span class="text-danger">*</span></label>
                                        <textarea name="template" id="template" cols="30" rows="10" class="form-control" required>@include('components.email_template')</textarea>
                                        @error('template')
                                            <span class="text-danger small">{{ $message }}</span>
                                        @enderror
                                    </div>
                                    <div>
                                        Short Codes <br>
                                        Order Link : [VIEW_LOCATION]
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-sm-12">
                                    <div class="text-right mt-4">
                                        <a class="btn btn-secondary text-uppercase font-weight-bold rounded pl-4 pr-4"
                                            href="{{ url()->previous() }}">Cancel</a>
                                        <button class="btn btn-primary text-uppercase font-weight-bold rounded pl-4 pr-4"
                                            type="submit">Create</button>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
        <small class="d-block text-end mt-3">

        </small>
    </div>
    </div>
@endsection

@section('scripts')
    <script src="{{ asset('assets/vendor/tinymce/tinymce.min.js') }}"></script>
    <script>
        tinymce.init({
            selector: 'textarea#template', // change this value according to your HTML
            a_plugin_option: true,
            a_configuration_option: 400,
            plugins: 'image',
            plugins: 'code',
            toolbar: 'image | alignjustify | alignleft | alignnone | alignright | blockquote | backcolor | bold | copy | cut | fontselect | fontsizeselect | forecolor | formatselect | h1 | h2 | h3 | h4 | h5 | h6 | indent | italic | language| lineheight | newdocument | outdent | paste | redo | remove | removeformat | selectall | strikethrough | styleselect | subscript | superscript | underline | undo | visualaid'
        });
    </script>
@endsection
