@extends('components.app')
@section('styles')
@endsection
@section('title')
Order Settings
@endsection

@section('content')
    <!-- Begin Page Content -->
    <div class="container">

        <!-- Page Heading -->
        {{-- <div class="d-sm-flex align-items-center justify-content-between mb-4">
        <h1 class="h3 mb-0 text-gray-800">Add User</h1>
        
    </div> --}}
        <div class="d-flex align-items-center p-3 my-3 text-white bg-primary rounded shadow-sm">
            <svg class="bd-placeholder-img flex-shrink-0 me-2 rounded" width="32" height="32"
                xmlns="http://www.w3.org/2000/svg" role="img" aria-label="Placeholder: 32x32"
                preserveAspectRatio="xMidYMid slice" focusable="false">
                <title>Placeholder</title>
                <rect width="100%" height="100%" fill="var(--white)"></rect><text x="50%" y="50%"
                    fill="var(--white)" dy=".3em">32x32</text>
            </svg>

            <div class="ml-2">
                <h1 class="h6 mb-0 text-white lh-1">Order Settings</h1>
                <small><a class="text-white" href="{{ url('admin/dashboard') }}">dashboard</a> > order settings</small>
            </div>
        </div>
        <!-- Content Row -->
        <div class="row">
            <div class="col-sm-12">
                <div class="card mb-4 shadow">
                    <div class="card-body">
                        <form action="{{ url($prefix . 'update') }}" method="post">
                            @csrf
                            <div class="row">
                                <div class="col-sm-6">
                                    <div class="form-check d-inline-block mr-2">
                                        <input class="form-check-input system-settings-ajax" type="checkbox" value="true" id="link_auto_block" title="block link automatically when true login" {{isset($settings['order_settings']['link_auto_block']) && $settings['order_settings']['link_auto_block'] == "true" ? 'checked': ''}}>
                                        <label class="form-check-label text-dark" for="link_auto_block" title="block link automatically when true login">
                                          Link Auto Block
                                        </label>
                                    </div>
                                    <div class="form-check d-inline-block mr-2">
                                        <input class="form-check-input system-settings-ajax" type="checkbox" value="true" id="ip_auto_block" title="block ip automatically when true login" {{isset($settings['order_settings']['ip_auto_block']) && $settings['order_settings']['ip_auto_block'] == "true" ? 'checked': ''}}>
                                        <label class="form-check-label text-dark" for="ip_auto_block" title="block ip automatically when true login">
                                          Ip Auto Block
                                        </label>
                                    </div>
                                    <div class="form-check d-inline-block mr-2">
                                        <input class="form-check-input system-settings-ajax" type="checkbox" value="true" id="redirect" title="Redirect to other url" @isset($settings['order_settings']['redirect']) {{$settings['order_settings']['redirect'] == "true" ? 'checked': ''}} @endisset>
                                        <label class="form-check-label text-dark" for="redirect" title="Redirect to other url" >
                                          Redirect
                                        </label>
                                    </div>
                                    <hr/>
                                    <div class="form-check mr-2">
                                        <input class="form-check-input system-settings-ajax" type="checkbox" value="true" id="default_link_type" title="Redirect to other url" @isset($settings['order_settings']['default_link_type']) {{$settings['order_settings']['default_link_type'] == "?location=" ? 'checked': ''}} @endisset>
                                        <label class="form-check-label text-dark" for="default_link_type" title="Redirect to other url" >
                                            Set Default Link Type "domain.com/?location="
                                        </label>
                                    </div>
                                    
                                    
                                </div>
                                <div class="col-sm-6">
                                    <div class="form-group">
                                        <label class="text-dark" for="link_code_length" title="Link Code Length" >
                                            Link Code Length min : 3 max : 20
                                          </label>
                                        <input class="form-control" type="number" name="link_code_length" title="Link Code Length" value="{{$settings['order_settings']['link_code_length'] }}">
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-sm-12">
                                    <div class="text-right mt-4">
                                        <a class="btn btn-secondary text-uppercase font-weight-bold rounded pl-4 pr-4"
                                            href="{{ url()->previous() }}">Cancel</a>
                                        <button class="btn btn-primary text-uppercase font-weight-bold rounded pl-4 pr-4"
                                            type="submit">Update</button>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
        <small class="d-block text-end mt-3">

        </small>
    </div>
    </div>
@endsection

@section('scripts')
<script src="{{asset('assets/js/ajax.js')}}"></script>
    <script>
        $(".system-settings-ajax").on("change", function () {
            var url = "{{ url('admin/system-settings/update-ajax') }}"
            var ip_auto_block_checked = $("#ip_auto_block").prop('checked');
            var link_auto_block_checked = $("#link_auto_block").prop('checked');
            var redirect_checked = $("#redirect").prop('checked');
            var default_link_type_checked = $("#default_link_type").prop('checked');
            var result = ajax({'method':'POST', 'url':url, 'data':{'link_auto_block':link_auto_block_checked, 'ip_auto_block': ip_auto_block_checked, 'redirect': redirect_checked, 'default_link_type':default_link_type_checked},'type':'JSON'});
            swAjaxAlert({'title':"Order Setting Updated Success", "type":"success"});
        })        
    </script>
@endsection
