@extends('components.app')
@section('styles')
@endsection
@section('title')
    Add Sms Api
@endsection

@section('content')
    <!-- Begin Page Content -->
    <div class="container">

        <!-- Page Heading -->
        {{-- <div class="d-sm-flex align-items-center justify-content-between mb-4">
        <h1 class="h3 mb-0 text-gray-800">Add User</h1>
        
    </div> --}}
        <div class="d-flex align-items-center p-3 my-3 text-white bg-primary rounded shadow-sm">
            <svg class="bd-placeholder-img flex-shrink-0 me-2 rounded" width="32" height="32"
                xmlns="http://www.w3.org/2000/svg" role="img" aria-label="Placeholder: 32x32"
                preserveAspectRatio="xMidYMid slice" focusable="false">
                <title>Placeholder</title>
                <rect width="100%" height="100%" fill="var(--white)"></rect><text x="50%" y="50%"
                    fill="var(--white)" dy=".3em">32x32</text>
            </svg>

            <div class="ml-2">
                <h1 class="h6 mb-0 text-white lh-1">Add Sms Api</h1>
                <small><a class="text-white" href="{{ url('admin/dashboard') }}">dashboard</a> > <a class="text-white"
                        href="{{ url($prefix . 'manage') }}">manage sms api</a> > add new sms api</small>
            </div>
        </div>
        <!-- Content Row -->
        <div class="row">
            <div class="col-sm-12">
                <div class="card mb-4 shadow">
                    <div class="card-body">
                        <form action="{{ url($prefix . 'store') }}" method="post">
                            @csrf
                            <div class="row">
                                <div class="col-sm-5">
                                    <div class="form-group">
                                        <label class="small">Name <span class="text-danger">*</span></label>
                                        <input type="text" class="form-control @error('name') is-invalid @enderror"
                                            value="{{ old('name') }}" name="name" aria-describedby="nameHelp"
                                            id="name" placeholder="Enter Gateway Name" required>
                                        @error('name')
                                            <span class="text-danger small">{{ $message }}</span>
                                        @enderror
                                    </div>
                                    <div class="form-group">
                                        <label class="small">Url <span class="text-danger">*</span></label>
                                        <input type="text" class="form-control @error('url') is-invalid @enderror"
                                            value="{{ old('url') }}" name="url" aria-describedby="urlHelp"
                                            id="url" placeholder="Enter Request Url" required>
                                        @error('url')
                                            <span class="text-danger small">{{ $message }}</span>
                                        @enderror
                                    </div>
                                    <div class="form-group">
                                        <label class="small">Method <span class="text-danger">*</span></label>
                                        <select name="method" id="method"
                                            class="form-control @error('method') is-invalid @enderror" required>
                                            <option value="">Select Request Method</option>
                                            <option value="get">GET</option>
                                            <option value="post">POST</option>
                                        </select>
                                        @error('method')
                                            <span class="text-danger small">{{ $message }}</span>
                                        @enderror
                                    </div>
                                    <div class="form-group">
                                        <label class="small">Authentication <span class="text-danger">*</span></label>
                                        <select name="authentication" id="authentication"
                                            class="form-control @error('authentication') is-invalid @enderror" required>
                                            <option value="">Authentication True/False</option>
                                            <option value="1">TRUE</option>
                                            <option value="0">FALSE</option>
                                        </select> 
                                        @error('authentication')
                                            <span class="text-danger small">{{ $message }}</span>
                                        @enderror
                                    </div>
                                    <div class="form-group use_token" style="display: none;">
                                        <label class="small">Use Token <span class="text-danger">*</span></label>
                                        <select name="use_token" id="use_token"
                                            class="form-control @error('use_token') is-invalid @enderror" >
                                            <option value="">Use token True/False</option>
                                            <option value="1">TRUE</option>
                                            <option value="0">FALSE</option>
                                        </select> 
                                        @error('use_token')
                                            <span class="text-danger small">{{ $message }}</span>
                                        @enderror
                                    </div>
                                    <div class="form-group token" style="display: none;">
                                        <label class="small">Token <span class="text-danger">*</span></label>
                                        <textarea
                                            class="form-control @error('token') is-invalid @enderror"
                                            name="token"
                                            aria-describedby="tokenHelp" id="token"
                                            placeholder="Enter Auth Token ex: Bearer 1234567890">{{ old('token') }}</textarea>
                                        @error('token')
                                            <span class="text-danger small">{{ $message }}</span>
                                        @enderror
                                    </div>
                                    <div class="form-group auth" style="display: none;">
                                        <label class="small">Username <span class="text-danger">*</span></label>
                                        <input type="text"
                                            class="form-control @error('auth_username') is-invalid @enderror"
                                            value="{{ old('auth_username') }}" name="auth_username"
                                            aria-describedby="auth_usernameHelp" id="auth_username"
                                            placeholder="Enter Auth Username">
                                        @error('auth_username')
                                            <span class="text-danger small">{{ $message }}</span>
                                        @enderror
                                    </div>
                                    <div class="form-group auth" style="display: none;">
                                        <label class="small">Password <span class="text-danger">*</span></label>
                                        <input type="text"
                                            class="form-control @error('auth_password') is-invalid @enderror"
                                            value="{{ old('auth_password') }}" name="auth_password"
                                            aria-describedby="auth_passwordHelp" id="auth_password"
                                            placeholder="Enter Auth Password">
                                        @error('auth_password')
                                            <span class="text-danger small">{{ $message }}</span>
                                        @enderror
                                    </div>
                                    <div class="form-group">
                                        <label class="small">Json Encode <span class="text-danger">*</span></label>
                                        <select name="json_encoded" id="json_encoded"
                                            class="form-control @error('json_encoded') is-invalid @enderror" required>
                                            <option value="">Json encode True/False</option>
                                            <option value="1">TRUE</option>
                                            <option value="0">FALSE</option>
                                        </select>
                                        @error('json_encoded')
                                            <span class="text-danger small">{{ $message }}</span>
                                        @enderror
                                    </div>
                                    <div class="form-group">
                                        <label class="small">Base64 Encoded Authentication <span class="text-danger">*</span></label>
                                        <select name="base64_encoded_authentication" id="base64_encoded_authentication"
                                            class="form-control @error('base64_encoded_authentication') is-invalid @enderror"
                                            required>
                                            <option value="">Base64 Encoded Authentication True/False</option>
                                            <option value="1">TRUE</option>
                                            <option value="0">FALSE</option>
                                        </select>
                                        @error('base64_encoded_authentication')
                                            <span class="text-danger small">{{ $message }}</span>
                                        @enderror
                                    </div>
                                    <div class="form-group">
                                        <label class="small">Sender Parameter<span class="text-danger">*</span></label>
                                        <input type="text"
                                            class="form-control @error('sender_parameter') is-invalid @enderror"
                                            value="{{ old('sender_parameter') }}" name="sender_parameter"
                                            aria-describedby="sender_parameterHelp" id="sender_parameter"
                                            placeholder="Sender Parameter" required>
                                        @error('sender_parameter')
                                            <span class="text-danger small">{{ $message }}</span>
                                        @enderror
                                    </div>
                                    <div class="form-group">
                                        <label class="small">To Parameter<span class="text-danger">*</span></label>
                                        <input type="text"
                                            class="form-control @error('to_parameter') is-invalid @enderror"
                                            value="{{ old('to_parameter') }}" name="to_parameter"
                                            aria-describedby="sender_parameterHelp" id="to_parameter"
                                            placeholder="To Parameter" required>
                                        @error('to_parameter')
                                            <span class="text-danger small">{{ $message }}</span>
                                        @enderror
                                    </div>
                                    <div class="form-group">
                                        <label class="small">Message Parameter<span class="text-danger">*</span></label>
                                        <input type="text"
                                            class="form-control @error('message_parameter') is-invalid @enderror"
                                            value="{{ old('message_parameter') }}" name="message_parameter"
                                            aria-describedby="sender_parameterHelp" id="message_parameter"
                                            placeholder="Message Parameter" required>
                                        @error('message_parameter')
                                            <span class="text-danger small">{{ $message }}</span>
                                        @enderror
                                    </div>
                                    <div class="form-group">
                                        <label class="small">Api Type <span class="text-danger">*</span></label>
                                        <select name="api_type" id="api_type"
                                            class="form-control @error('api_type') is-invalid @enderror" required>
                                            <option value="">Api Type</option>
                                            <option value="sms">Sms</option>
                                            <option value="unicode">Unicode</option>
                                            <option value="flash">Flash</option>
                                        </select>
                                        @error('api_type')
                                            <span class="text-danger small">{{ $message }}</span>
                                        @enderror
                                    </div>
                                </div>
                                <div class="col-sm-7">
                                    <label class="small">Other Parameters and Values</label>
                                    <div class="add-line-div">
                                        <div class="row" id="row_1">
                                            <div class="col-sm-5">
                                                <input type="text"
                                                    class="form-control @error('parameter') is-invalid @enderror"
                                                    name="parameter[]" aria-describedby="parameterHelp" id="parameter"
                                                    placeholder="Parameter">
                                                @error('parameter')
                                                    <span class="text-danger small">{{ $message }}</span>
                                                @enderror
                                            </div>
                                            <div class="col-sm-5">
                                                <input type="text"
                                                    class="form-control @error('value') is-invalid @enderror"
                                                    name="value[]" aria-describedby="valueHelp" id="value"
                                                    placeholder="Value">
                                                @error('value')
                                                    <span class="text-danger small">{{ $message }}</span>
                                                @enderror
                                            </div>
                                            <div class="col-sm-2 first-button">
                                                <button class="btn btn-info add-line" id="1" type="button"><i
                                                        class="fas fa-plus"></i></button>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="bg-light p-2">
                                        <span class="small">
                                            parameters not included spaces or special charactors<br>
                                            Ex: not first name or first-name <br>
                                            its should be first_name
                                        </span>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-sm-12">
                                    <div class="text-right mt-4">
                                        <a class="btn btn-secondary text-uppercase font-weight-bold rounded pl-4 pr-4"
                                            href="{{ url()->previous() }}">Cancel</a>
                                        <button class="btn btn-primary text-uppercase font-weight-bold rounded pl-4 pr-4"
                                            type="submit">Create</button>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
        <small class="d-block text-end mt-3">

        </small>
    </div>
    </div>
@endsection

@section('scripts')
    <script>
        $("#authentication").change(function(e) {
            if (this.value == "1") {
                $(".auth").show();
                $(".use_token").show();
            } else {
                $(".auth").hide();
                $(".use_token").hide();
            }
        })
        $("#use_token").change(function(e) {
            if (this.value == "1") {
                $(".auth").hide();
                $(".token").show();
            } else {
                $(".auth").show();
                $(".token").hide();
            }
        })

        $(document).on("click", ".add-line", function(e) {
            e.preventDefault();
            var id = this.id;
            id++
            $(".add-line-div").append(
                '<div class="row mt-2" id="row_' + id + '">' +
                '<div class="col-sm-5">' +
                '<input type="text" class="form-control" name="parameter[]" aria-describedby="parameterHelp" id="parameter"  placeholder="Parameter">' +
                '</div>' +
                '<div class="col-sm-5">' +
                '<input type="text" class="form-control" name="value[]" aria-describedby="valueHelp" id="value"  placeholder="Value">' +
                '</div>' +
                '<div class="col-sm-2">' +
                '<button class="btn btn-danger delete-line" id="' + id +
                '" type="button"><i class="fas fa-trash"></i></button>' +
                '</div>' +
                '</div>'
            );
            $(".add-line").removeAttr('id');
            $(".add-line").attr('id', id);
        });

        $(document).on('click', ".delete-line", function(e) {
            e.preventDefault();
            var id = this.id
            $("#row_" + id).remove();
        })
    </script>
@endsection
