@extends('components.app')
@section('styles')
@endsection
@section('title')
    Edit SMTP
@endsection

@section('content')
    <!-- Begin Page Content -->
    <div class="container">

        <!-- Page Heading -->
        {{-- <div class="d-sm-flex align-items-center justify-content-between mb-4">
        <h1 class="h3 mb-0 text-gray-800">Edit User</h1>
        
    </div> --}}
        <div class="d-flex align-items-center p-3 my-3 text-white bg-primary rounded shadow-sm">
            <svg class="bd-placeholder-img flex-shrink-0 me-2 rounded" width="32" height="32"
                xmlns="http://www.w3.org/2000/svg" role="img" aria-label="Placeholder: 32x32"
                preserveAspectRatio="xMidYMid slice" focusable="false">
                <title>Placeholder</title>
                <rect width="100%" height="100%" fill="var(--white)"></rect><text x="50%" y="50%"
                    fill="var(--white)" dy=".3em">32x32</text>
            </svg>

            <div class="ml-2">
                <h1 class="h6 mb-0 text-white lh-1">Edit SMTP</h1>
                <small><a class="text-white" href="{{ url('admin/dashboard') }}">dashboard</a> > <a class="text-white"
                        href="{{ url($prefix . 'manage') }}">manage SMTP</a> > edit SMTP</small>
            </div>
        </div>
        <!-- Content Row -->
        <div class="row">
            <div class="col-sm-12">
                <div class="card mb-4 shadow">
                    <div class="card-body">
                        <form action="{{ url($prefix . 'update') }}" method="post">
                            @csrf
                            <input type="hidden" name="id" value="{{ $data->id }}">
                            <div class="row">
                                <div class="col-sm-6">
                                    <div class="form-group">
                                        <label class="small">Name <span class="text-danger">*</span></label>
                                        <input type="text" class="form-control @error('name') is-invalid @enderror"
                                            name="name" aria-describedby="nameHelp" id="name"
                                            placeholder="Template Name" value="{{ $data->name }}" required>
                                        @error('name')
                                            <span class="text-danger small">{{ $message }}</span>
                                        @enderror
                                    </div>
                                    <div class="form-group">
                                        <label class="small">Host Name <span class="text-danger">*</span></label>
                                        <input type="text" class="form-control @error('host_name') is-invalid @enderror"
                                            name="host_name" aria-describedby="hostnameHelp" id="host_name"
                                            placeholder="Host Name" value="{{ $data->host_name }}" required>
                                        @error('host_name')
                                            <span class="text-danger small">{{ $message }}</span>
                                        @enderror
                                    </div>
                                    <div class="form-group">
                                        <label class="small">Port <span class="text-danger">*</span></label>
                                        <input type="text" class="form-control @error('port') is-invalid @enderror"
                                            name="port" aria-describedby="portHelp" id="port" placeholder="Port"
                                            value="{{ $data->port }}" required>
                                        @error('port')
                                            <span class="text-danger small">{{ $message }}</span>
                                        @enderror
                                    </div>
                                    <div class="form-group">
                                        <label class="small">Driver <span class="text-danger">*</span></label>
                                        <select name="driver" id="driver"
                                            class="form-control @error('driver') is-invalid @enderror" required>
                                            <option value="" selected disabled>Select Driver*</option>
                                                <option value="smtp" @if($data->driver == 'smtp') selected @endif>SMTP</option>
                                                <option value="imap" @if($data->driver == 'imap') selected @endif>IMAP</option>
                                                <option value="pop" @if($data->driver == 'pop') selected @endif>POP</option>
                                        </select>
                                        @error('driver')
                                            <span class="text-danger small">{{ $message }}</span>
                                        @enderror
                                    </div>
                                </div>
                                <div class="col-sm-6">
                                    <div class="form-group">
                                        <label class="small">Username <span class="text-danger">*</span></label>
                                        <input type="text" class="form-control @error('username') is-invalid @enderror"
                                            name="username" aria-describedby="usernameHelp" id="username"
                                            placeholder="Username" value="{{ $data->username }}" required>
                                        @error('username')
                                            <span class="text-danger small">{{ $message }}</span>
                                        @enderror
                                    </div>
                                    <div class="form-group">
                                        <label class="small">Password <span class="text-danger">*</span></label>
                                        <input type="text" class="form-control @error('password') is-invalid @enderror"
                                            name="password" aria-describedby="passwordHelp" id="password"
                                            placeholder="password" value="{{ $data->password }}" required>
                                        @error('password')
                                            <span class="text-danger small">{{ $message }}</span>
                                        @enderror
                                    </div>
                                    <div class="form-group">
                                        <label class="small">Encryption Type (TLS, SSL) <span
                                                class="text-danger">*</span></label>
                                        <input type="text"
                                            class="form-control @error('encrypted_type') is-invalid @enderror"
                                            name="encrypted_type" aria-describedby="encryptedtypeHelp" id="encrypted_type"
                                            placeholder="Encrypted Type" value="{{ $data->encrypted_type }}" required>
                                        @error('encrypted_type')
                                            <span class="text-danger small">{{ $message }}</span>
                                        @enderror
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-sm-12">
                                    <div class="text-right mt-4">
                                        <a class="btn btn-secondary text-uppercase font-weight-bold rounded pl-4 pr-4"
                                            href="{{ url()->previous() }}">Cancel</a>
                                        <button class="btn btn-primary text-uppercase font-weight-bold rounded pl-4 pr-4"
                                            type="submit">Update</button>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
        <small class="d-block text-end mt-3">

        </small>
    </div>
    </div>
@endsection

@section('scripts')
    <script></script>
@endsection
