@extends('components.app')
@section('styles')
@endsection
@section('title')
    Edit Permission
@endsection

@section('content')

<!-- Begin Page Content -->
<div class="container">
    
    <!-- Page Heading -->
    {{-- <div class="d-sm-flex align-items-center justify-content-between mb-4">
        <h1 class="h3 mb-0 text-gray-800">Edit User</h1>
        
    </div> --}}
    <div class="d-flex align-items-center p-3 my-3 text-white bg-primary rounded shadow-sm">
        <svg class="bd-placeholder-img flex-shrink-0 me-2 rounded" width="32" height="32" xmlns="http://www.w3.org/2000/svg" role="img" aria-label="Placeholder: 32x32" preserveAspectRatio="xMidYMid slice" focusable="false"><title>Placeholder</title><rect width="100%" height="100%" fill="var(--white)"></rect><text x="50%" y="50%" fill="var(--white)" dy=".3em">32x32</text></svg>

        <div class="ml-2">
          <h1 class="h6 mb-0 text-white lh-1">Edit Permission</h1>
          <small><a class="text-white" href="{{url('admin/dashboard')}}">dashboard</a> > <a class="text-white" href="{{url($prefix.'manage')}}">manage permission</a> > edit permission</small>
        </div>
    </div>
    <!-- Content Row -->
    <div class="row">
            <div class="col-sm-12">
                <div class="card mb-4 shadow">
                    <div class="card-body">
                        <div class="row">
                            <div class="col-sm-3"></div>
                            <div class="col-sm-6">
                                <form action="{{url($prefix.'update')}}" method="post"> 
                                    @csrf
                                    <input type="hidden" name="id" value="{{$permission->id}}">
                                    <div class="form-group small mb-2">
                                        <label class="small">Guard <span class="text-danger">*</span></label>
                                        <select name="guard_name" id="guard_name" class="form-control @error('guard_name') is-invalid @enderror" >
                                            <option value="web" @if ($permission->guard_name == "web") selected @endif>web</option>
                                            <option value="admin" @if ($permission->guard_name == "admin") selected @endif>admin</option>
                                        </select>
                                        @error('guard_name')<span class="text-danger small">{{$message}}</span>@enderror 
                                    </div>
                                    <div class="form-group">
                                        <label class="small">Name <span class="text-danger">*</span></label>
                                        <input type="text" class="form-control @error('name') is-invalid @enderror" value="{{$permission->name}}" name="name" aria-describedby="nameHelp" placeholder="Enter Name...">
                                        @error('name')<span class="text-danger small">{{$message}}</span>@enderror 
                                    </div>
                                    
                                    <div class="text-right">
                                        <a class="btn btn-secondary text-uppercase font-weight-bold rounded pl-4 pr-4" href="{{url()->previous()}}">Cancel</a>
                                        <button class="btn btn-primary text-uppercase font-weight-bold rounded pl-4 pr-4" type="submit">Update</button>
                                    </div>
                                </form>
                            </div>
                            <div class="col-sm-3"></div>
                        </div>
                    </div>
                </div>
                
            </div>
        </div>
        <small class="d-block text-end mt-3">
          
        </small>
      </div>
</div>

@endsection

