@extends('components.app')
@section('styles')
@endsection
@section('title')
    View User
@endsection

@section('content')

<!-- Begin Page Content -->
<div class="container">
    
    <div class="d-flex align-items-center p-3 my-3 text-white bg-primary rounded shadow-sm">
        <svg class="bd-placeholder-img flex-shrink-0 me-2 rounded" width="32" height="32" xmlns="http://www.w3.org/2000/svg" role="img" aria-label="Placeholder: 32x32" preserveAspectRatio="xMidYMid slice" focusable="false"><title>Placeholder</title><rect width="100%" height="100%" fill="var(--white)"></rect><text x="50%" y="50%" fill="var(--white)" dy=".3em">32x32</text></svg>

        <div class="ml-2">
          <h1 class="h6 mb-0 text-white lh-1">View User</h1>
          <small><a class="text-white" href="{{url('admin/dashboard')}}">dashboard</a> > <a class="text-white" href="{{url($prefix.'manage')}}">manage users</a> > view user</small>
        </div>
    </div>
    <!-- Content Row -->
    <div class="row">
            <div class="col-sm-12">
                <div class="card mb-4 shadow">
                    <div class="card-body">
                        <div class="row">
                            <div class="col-sm-3"></div>
                            <div class="col-sm-6">
                                    <div class="form-group">
                                        <label class="small text-dark">Name</label>
                                        <input type="text" class="form-control" readonly value="{{$user->name}}"> 
                                    </div>
                                    <div class="form-group">
                                        <label class="small text-dark">Email</label>
                                        <input type="email" class="form-control" readonly value="{{$user->email}}">
                                    </div>
                                    <div class="form-group">
                                        <label class="small text-dark">Teligram</label>
                                        <input type="text" class="form-control" readonly value="{{$user->telegram}}">
                                    </div>
                                    <div class="form-group">
                                        <label class="small text-dark">Type</label>
                                        <input type="text" class="form-control" readonly value="{{$user->role_name}}">
                                    </div>
                                    <div class="form-group">
                                        <label class="small text-dark">Status</label>
                                        <input type="text" class="form-control" readonly value="@if($user->status == 1) active @else block @endif">
                                    </div>
                                    <div class="form-group">
                                        <label class="small">Secret Code<span class="text-danger">*</span></label>
                                        <input type="text" class="form-control" value="{{$user->secret_code}}" readonly>
                                        
                                    </div>
                                    <div class="text-right">
                                        <a class="btn btn-primary text-uppercase font-weight-bold rounded pl-4 pr-4 mr-2" href="{{url()->previous()}}"><i class="fas fa-arrow-left"></i> back</button>
                                        <a href="{{url($prefix.'edit?id='.$user->id)}}" class="btn btn-secondary">
                                            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-pencil-square" viewBox="0 0 16 16">
                                            <path d="M15.502 1.94a.5.5 0 0 1 0 .706L14.459 3.69l-2-2L13.502.646a.5.5 0 0 1 .707 0l1.293 1.293zm-1.75 2.456-2-2L4.939 9.21a.5.5 0 0 0-.121.196l-.805 2.414a.25.25 0 0 0 .316.316l2.414-.805a.5.5 0 0 0 .196-.12l6.813-6.814z"/>
                                            <path fill-rule="evenodd" d="M1 13.5A1.5 1.5 0 0 0 2.5 15h11a1.5 1.5 0 0 0 1.5-1.5v-6a.5.5 0 0 0-1 0v6a.5.5 0 0 1-.5.5h-11a.5.5 0 0 1-.5-.5v-11a.5.5 0 0 1 .5-.5H9a.5.5 0 0 0 0-1H2.5A1.5 1.5 0 0 0 1 2.5v11z"/>
                                          </svg>
                                          edit
                                        </a>
                                    </div>
                                </form>
                            </div>
                            <div class="col-sm-3"></div>
                        </div>
                    </div>
                </div>
                
            </div>
        </div>
        <small class="d-block text-end mt-3">
          
        </small>
      </div>
</div>

@endsection

