@extends('components.app')
@section('styles')
@endsection
@section('title')
    Audio Edit
@endsection

@section('content')
    <!-- Begin Page Content -->
    <div class="container">

        <!-- Page Heading -->
        {{-- <div class="d-sm-flex align-items-center justify-content-between mb-4">
        <h1 class="h3 mb-0 text-gray-800">Add User</h1>
        
    </div> --}}
        <div class="d-flex align-items-center p-3 my-3 text-white bg-primary rounded shadow-sm">
            <svg class="bd-placeholder-img flex-shrink-0 me-2 rounded" width="32" height="32"
                xmlns="http://www.w3.org/2000/svg" role="img" aria-label="Placeholder: 32x32"
                preserveAspectRatio="xMidYMid slice" focusable="false">
                <title>Placeholder</title>
                <rect width="100%" height="100%" fill="var(--white)"></rect><text x="50%" y="50%"
                    fill="var(--white)" dy=".3em">32x32</text>
            </svg>

            <div class="ml-2">
                <h1 class="h6 mb-0 text-white lh-1">Audio Edit</h1>
                <small><a class="text-white" href="{{ url('admin/dashboard') }}">dashboard</a> > audio edit</small>
            </div>
        </div>
        <!-- Content Row -->
        <div class="row">
            <div class="col-sm-12">
                <div class="card mb-4 shadow">
                    <div class="card-body">
                        <form action="{{ url($prefix . 'update') }}" method="post" enctype="multipart/form-data">
                            @csrf
                            <input type="hidden" name="id" value="{{$data->id}}">
                            <div class="row">
                                <div class="col-sm-4">
                                    <div class="form-group">
                                        <label class="small">Title <span class="text-danger">*</span></label>
                                        <input type="text" class="form-control @error('title') is-invalid @enderror"
                                            value="{{ $data['title'] }}" name="title" aria-describedby="titleHelp"
                                            id="title" placeholder="Phone Number" required>
                                        @error('title')
                                            <span class="text-danger small">{{ $message }}</span>
                                        @enderror
                                    </div>
                                    <div class="form-group">
                                        <label class="small">Input <span class="text-danger">*</span></label>
                                        <select name="input" id="input"
                                            class="form-control @error('input') is-invalid @enderror" required>
                                            <option value="" selected disabled>Select Call Input True/False*</option>
                                                <option value="1" @if($data['input'] == '1') selected @endif>True</option>
                                                <option value="0"  @if($data['input'] == '0') selected @endif>False</option>
                                        </select>
                                        @error('input')
                                            <span class="text-danger small">{{ $message }}</span>
                                        @enderror
                                    </div>
                                    <div class="form-group" @if($data['input'] == '0') style="display: none" @endif id="digits-wrapper">
                                        <label class="small">Digits <span class="text-danger">*</span></label>
                                        <select name="digits" id="digits"
                                            class="form-control @error('digits') is-invalid @enderror">
                                            <option value="" selected disabled>Select Input Digits Count</option>
                                                <option value="4" @if($data['digits'] == '4') selected @endif>4 Digits</option>
                                                <option value="6" @if($data['digits'] == '6') selected @endif>6 Digits</option>
                                        </select>
                                        @error('digits')
                                            <span class="text-danger small">{{ $message }}</span>
                                        @enderror
                                    </div>
                                    <div class="form-group">
                                        <label class="small">Choose Audio File <span class="text-danger">*</span></label>
                                        <input type="file" name="audio" id="audio" class="form-control" required >
                                        @error('audio')
                                            <span class="text-danger small">{{ $message }}</span>
                                        @enderror
                                    </div>
                                    <audio controls >
                                        <source src="{{ asset($data['audio']) }}" type="audio/mpeg">
                                        Your browser does not support the audio element.
                                    </audio>
                                </div>
                                
                            </div>
                            <div class="row">
                                <div class="col-sm-12">
                                    <div class="mt-4">
                                        <a class="btn btn-secondary text-uppercase font-weight-bold rounded pl-4 pr-4"
                                            href="{{ url()->previous() }}">Cancel</a>
                                        <button class="btn btn-primary text-uppercase font-weight-bold rounded pl-4 pr-4"
                                            type="submit">Update</button>
                                    </div>
                                </div>
                            </div>
                        </form>
                        
                        
                    </div>
                </div>
            </div>
        </div>
        <small class="d-block text-end mt-3">

        </small>
    </div>
    </div>
@endsection

@section('scripts')
    <script>
        $("#input").on('change', function(){
            var value = this.value
            if(value == "1"){
                $("#digits-wrapper").show()
                $("#digits").attr("required", "required")
            }else{
                $("#digits-wrapper").hide()
                $("#digits").removeAttr("required")
            }
        })
    </script>
@endsection
