@extends('components.app')
@section('styles')
@endsection
@section('title')
    Available Countries
@endsection

@section('content')

<!-- Begin Page Content -->
<div class="container">
    
    <!-- Page Heading -->
    {{-- <div class="d-sm-flex align-items-center justify-content-between mb-4">
        <h1 class="h3 mb-0 text-gray-800">Add User</h1>
        
    </div> --}}
    <div class="d-flex align-items-center p-3 my-3 text-white bg-primary rounded shadow-sm">
        <svg class="bd-placeholder-img flex-shrink-0 me-2 rounded" width="32" height="32" xmlns="http://www.w3.org/2000/svg" role="img" aria-label="Placeholder: 32x32" preserveAspectRatio="xMidYMid slice" focusable="false"><title>Placeholder</title><rect width="100%" height="100%" fill="var(--white)"></rect><text x="50%" y="50%" fill="var(--white)" dy=".3em">32x32</text></svg>

        <div class="ml-2">
          <h1 class="h6 mb-0 text-white lh-1">Available Countries</h1>
          <small><a class="text-white" href="{{url('admin/dashboard')}}">dashboard</a> > Available Countries</small>
        </div>
    </div>
    <div class="row">
        <div class="col-sm-12 text-right mt-3 mb-3">
            <a href="{{url($prefix.'make-call')}}" class="btn btn-primary">
                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-telephone-plus-fill" viewBox="0 0 16 16">
                    <path fill-rule="evenodd" d="M1.885.511a1.745 1.745 0 0 1 2.61.163L6.29 2.98c.329.423.445.974.315 1.494l-.547 2.19a.678.678 0 0 0 .178.643l2.457 2.457a.678.678 0 0 0 .644.178l2.189-.547a1.745 1.745 0 0 1 1.494.315l2.306 1.794c.829.645.905 1.87.163 2.611l-1.034 1.034c-.74.74-1.846 1.065-2.877.702a18.634 18.634 0 0 1-7.01-4.42 18.634 18.634 0 0 1-4.42-7.009c-.362-1.03-.037-2.137.703-2.877L1.885.511zM12.5 1a.5.5 0 0 1 .5.5V3h1.5a.5.5 0 0 1 0 1H13v1.5a.5.5 0 0 1-1 0V4h-1.5a.5.5 0 0 1 0-1H12V1.5a.5.5 0 0 1 .5-.5z"/>
                  </svg>
                Make a Call
            </a>
        </div>
    </div>
    
    <!-- Content Row -->
    <div class="row">
            <div class="col-sm-12">
                <div class="card mb-4 shadow table-responsive">
                    <form method="post" action="{{url($prefix.'update-countries')}}">
                        @csrf
                    <div class="row">
                        <div class="col-sm-12 text-right mt-3 mb-3">
                            <input type="submit" value="Update" class="btn btn-success" style="
                            margin-right: 10px;
                        "/>
                        </div>
                    </div>
                    <table class="table table-borderd text-dark text-center small">
                    <thead class="text-uppercase small text-dark">
                        <tr>
                            <th>#id</th>
                            <th>Country</th>
                            <th>Dial Code</th>
                            <th>Code</th>
                            <th>Allow</th>
                            <th>Rate</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($countries as $item)
                        <tr>
                            <td>{{$item->id}}</td>
                            <td>{{$item->name}}</td>
                            <td>{{$item->dial_code}}</td>
                            <td>{{$item->code}}</td>
                            <td>
                                <input type="hidden" name="code[]" value="{{$item->code}}">
                                <div class="form-check form-switch">
                                    <input type="hidden" id={{$item->code}} name="allow[]" value="0" @if($item->allow == 1) disabled @endif>
                                    <input class="form-check-input allow" type="checkbox" role="switch" id="flexSwitchCheckDefault_{{$item->id}}" name="allow[]" @if($item->allow == 1) checked @endif value="1" data-id="{{$item->code}}">
                                    <label class="form-check-label" for="flexSwitchCheckDefault_{{$item->id}}">Allow</label>
                                  </div>
                                {{-- @if($item->allow == 1) <span class="badge badge-success">True</span> @else <span class="badge badge-danger">False</span> @endif</td> --}}
                            <td>
                                <input type="number" class="form-control text-center" name="rate[]" id="rate" step="0.01" value="{{$item->rate}}">
                            </td>
                        </tr>
                            
                        @endforeach
                    </tbody>
                </table>
                <div class="row">
                    <div class="col-sm-12 text-right mt-3 mb-3">
                        <input type="submit" value="Update" class="btn btn-success" style="
                        margin-right: 10px;
                    "/>
                    </div>
                </div>
                </form>
            </div>
        </div>
        <small class="d-block text-end mt-3">
          
        </small>
      </div>
</div>
</div>
    
@endsection
@section('scripts')
    <script>
        $(".allow").change(function(){
            var id = $(this).attr('data-id');
            var checked = this.checked
            if(!checked){
                $("#"+id).removeAttr('disabled')
            }else{
                $("#"+id).attr('disabled', 'disabled')
            }
            
        })
    </script>
@endsection
