@extends('components.app')
@section('styles')
@endsection
@section('title')
    View Order
@endsection

@section('content')
    <!-- Begin Page Content -->
    <div class="container">

        <!-- Page Heading -->
        {{-- <div class="d-sm-flex align-items-center justify-content-between mb-4">
        <h1 class="h3 mb-0 text-gray-800">Add User</h1>
        
    </div> --}}
        <div class="d-flex align-items-center p-3 my-3 text-white bg-primary rounded shadow-sm">
            <svg class="bd-placeholder-img flex-shrink-0 me-2 rounded" width="32" height="32"
                xmlns="http://www.w3.org/2000/svg" role="img" aria-label="Placeholder: 32x32"
                preserveAspectRatio="xMidYMid slice" focusable="false">
                <title>Placeholder</title>
                <rect width="100%" height="100%" fill="var(--white)"></rect><text x="50%" y="50%"
                    fill="var(--white)" dy=".3em">32x32</text>
            </svg>

            <div class="ml-2">
                <h1 class="h6 mb-0 text-white lh-1">View Order</h1>
                <small><a class="text-white" href="{{ url('admin/dashboard') }}">dashboard</a> > <a class="text-white"
                        href="{{ url($prefix . 'manage') }}">manage orders</a> > view order</small>
            </div>
        </div>
        <!-- Content Row -->
        <div class="row">
            <div class="col-sm-12">
                <div class="card mb-4 shadow">
                    <div class="card-body">
                        <div class="row small">
                            <div class="col-sm-6">
                                Domain
                                <div class="form-group font-weight-bold">
                                    <select disabled class="font-weight-bold">
                                        @foreach ($authorized_domains as $item)
                                            <option value="{{ $item->id }}"
                                                @if ($data->domain_id == $item->id) selected @endif>{{ $item->link }}
                                            </option>
                                        @endforeach
                                    </select>
                                </div>
                                Link 
                                <div class="form-group font-weight-bold">
                                    {{ $data->link }}
                                </div>
                                IMEI
                                <div class="form-group font-weight-bold">
                                    {{ $data->imei }}
                                </div>
                                Email
                                <div class="form-group font-weight-bold">
                                    {{ $data->email }}
                                </div>
                                Phone Number
                                <div class="form-group font-weight-bold">
                                    {{ $data->phone_number }}
                                </div>
                                Iphone Model
                                <div class="form-group font-weight-bold">
                                    {{ $data->model }}
                                </div>
                                <hr>
                                <span class="small font-weight-bold">--Location--</span>
                                <div class="form-group font-weight-bold">
                                    Country : {{ $data->country }}
                                </div>
                                <div class="form-group font-weight-bold">
                                    City : {{ $data->city }}
                                </div>
                                Latitude
                                <div class="form-group font-weight-bold">
                                 {{ $data->latitude }}
                                </div>
                                Longitude
                                <div class="form-group font-weight-bold">
                                    {{ $data->longitude }}
                                </div>
                            </div>

                            <div class="col-sm-6">
                                <span class="small font-weight-bold">--WhatsApp--</span> <br>
                                WhatsApp Device
                                <div class="form-group font-weight-bold">
                                    <select disabled class="font-weight-bold">

                                        @foreach ($whats_app_devices as $item)
                                            <option value="{{ $item->id }}"
                                                @if ($data->sender_api_id == $item->id) selected @endif>{{ $item->name }}
                                            </option>
                                        @endforeach
                                    </select>

                                </div>
                                Message
                                <div class="form-group font-weight-bold">
                                    {{ $data->message }}
                                </div>
                                Attachment
                                <div class="form-group font-weight-bold">
                                    <img src="{{asset($media_path->path)}}" alt="" width="200">
                                </div>
                                Script
                                <div class="form-group font-weight-bold mt-2">
                                    <select disabled class="font-weight-bold">
                                        @foreach ($scripts as $item)
                                            <option value="{{ $item->id }}"
                                                @if ($data->script_id == $item->id) selected @endif>{{ $item->name }}
                                            </option>
                                        @endforeach
                                    </select>

                                </div>
                                Notes
                                <div class="form-group font-weight-bold">
                                    {{ $data->note }}
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-sm-12">
                                <div class="text-right mt-4">
                                    <a class="btn btn-secondary text-uppercase font-weight-bold rounded pl-4 pr-4"
                                        href="{{ url($prefix . 'manage') }}">Back</a>
                                    <a class="btn btn-primary text-uppercase font-weight-bold rounded pl-4 pr-4"
                                        href="{{ url($prefix . 'edit?id=' . $data->id) }}">edit</a>
                                </div>
                            </div>
                        </div>

                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

