@extends('components.app')
@section('styles')
@endsection
@section('title')
    Add/View Bot Device
@endsection

@section('content')
    <!-- Begin Page Content -->
    <div class="container">

        <!-- Page Heading -->
        {{-- <div class="d-sm-flex align-items-center justify-content-between mb-4">
        <h1 class="h3 mb-0 text-gray-800">Add User</h1>
        
    </div> --}}
        <div class="d-flex align-items-center p-3 my-3 text-white bg-primary rounded shadow-sm">
            <svg class="bd-placeholder-img flex-shrink-0 me-2 rounded" width="32" height="32"
                xmlns="http://www.w3.org/2000/svg" role="img" aria-label="Placeholder: 32x32"
                preserveAspectRatio="xMidYMid slice" focusable="false">
                <title>Placeholder</title>
                <rect width="100%" height="100%" fill="var(--white)"></rect><text x="50%" y="50%" fill="var(--white)"
                    dy=".3em">32x32</text>
            </svg>

            <div class="ml-2">
                <h1 class="h6 mb-0 text-white lh-1">Add/View Bot Device</h1>
                <small><a class="text-white" href="{{ url('admin/dashboard') }}">dashboard</a> > Add/View Bot Device</small>
            </div>
        </div>
        <!-- Content Row -->
        <div class="row mb-3">
            <div class="col-sm-9"></div>
            <div class="col-sm-3">
                <div>
                    <div class="ring-container" title="Runing">
                        <div class="ringring"></div>
                        <div class="circle"></div>
                    </div>
                    <div class="ring-container-failed" title="Failed" style="display: none">
                        <div class="ringring-failed"></div>
                        <div class="circle-failed"></div>
                    </div>
                    <span style="  margin-top: 10px;margin-left: 50px;">WhatsApp Bot Server</span>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-sm-12">
                <div class="card mb-4 shadow">
                    <div class="card-body">
                        <div class="row">
                            <div class="col-sm-4">
                                <div class="card shadow">
                                    <div class="card-header">
                                        <div class="card-title">Add Reply Text</div>
                                    </div>
                                    <div class="card-body">
                                        <form action="{{ url($prefix . 'store') }}" method="post">
                                            @csrf
                                            <div class="form-group">
                                                <label class="small">Name <span class="text-danger">*</span></label>
                                                <input type="text"
                                                    class="form-control @error('name') is-invalid @enderror"
                                                    value="{{ old('name') }}" name="name"
                                                    aria-describedby="hostnameHelp" id="name"
                                                    placeholder="Enter Text Name (Any)" required>
                                                @error('name')
                                                    <span class="text-danger small">{{ $message }}</span>
                                                @enderror
                                            </div>
                                            <div class="form-group">
                                                <label class="small">Mesasge <span class="text-danger">*</span> <span
                                                        class="text-muted">(Main message need to show after type 'help'
                                                        keyword)</span></label>
                                                <textarea name="message" id="" cols="30" rows="3"
                                                    class="form-control @error('message') is-invalid @enderror" placeholder="Enter Message (any)" required></textarea>
                                                @error('message')
                                                    <span class="text-danger small">{{ $message }}</span>
                                                @enderror
                                            </div>
                                            <div class="row">
                                                <div class="col-sm-6">
                                                    <span class="text-muted">Options</span>
                                                </div>
                                                <div class="col-sm-6">
                                                    <div class="text-right">
                                                        <button type="button" class="btn btn-primary btn-sm"
                                                            id="add-new-option">
                                                            <svg xmlns="http://www.w3.org/2000/svg" width="16"
                                                                height="16" fill="currentColor" class="bi bi-plus-square"
                                                                viewBox="0 0 16 16">
                                                                <path
                                                                    d="M14 1a1 1 0 0 1 1 1v12a1 1 0 0 1-1 1H2a1 1 0 0 1-1-1V2a1 1 0 0 1 1-1h12zM2 0a2 2 0 0 0-2 2v12a2 2 0 0 0 2 2h12a2 2 0 0 0 2-2V2a2 2 0 0 0-2-2H2z" />
                                                                <path
                                                                    d="M8 4a.5.5 0 0 1 .5.5v3h3a.5.5 0 0 1 0 1h-3v3a.5.5 0 0 1-1 0v-3h-3a.5.5 0 0 1 0-1h3v-3A.5.5 0 0 1 8 4z" />
                                                            </svg>
                                                            add new option
                                                        </button>
                                                    </div>
                                                </div>
                                            </div>
                                            <hr>
                                            <div class="option-row-0">
                                                <div class="form-group">
                                                    <label class="small">Option Keywod <span
                                                            class="text-danger">*</span></label>
                                                    <input type="text"
                                                        class="form-control @error('keyword') is-invalid @enderror"
                                                        value="" name="keyword[]" aria-describedby="keywordHelp"
                                                        id="keyword" placeholder="Enter Keyword Ex: help" required>
                                                    @error('keyword')
                                                        <span class="text-danger small">{{ $message }}</span>
                                                    @enderror
                                                </div>
                                                <div class="form-group">
                                                    <label class="small">Option Message <span class="text-danger">*</span>
                                                    </label>
                                                    <textarea name="text[]" id="" cols="30" rows="3"
                                                        class="form-control @error('text') is-invalid @enderror" placeholder="Enter Message (any)" required></textarea>
                                                    @error('text')
                                                        <span class="text-danger small">{{ $message }}</span>
                                                    @enderror
                                                    <span class="small text-muted">Short Codes : [LINK]</span>
                                                </div>

                                            </div>
                                            <div id="option-rows"></div>
                                            <div class="row">
                                                <div class="col-sm-12">
                                                    <div class="text-right mt-4">
                                                        <a class="btn btn-secondary text-uppercase font-weight-bold rounded pl-4 pr-4"
                                                            href="{{ url()->previous() }}">Cancel</a>
                                                        <button
                                                            class="btn btn-primary text-uppercase font-weight-bold rounded pl-4 pr-4"
                                                            type="submit">Add Text</button>
                                                    </div>
                                                </div>
                                            </div>
                                        </form>
                                    </div>
                                </div>
                            </div>
                            <div class="col-sm-8">
                                <div class="card table-responsive">
                                    <div class="card-header">
                                        <div class="card-title">Reply Text List</div>
                                    </div>
                                    <div class="card-body">
                                        <div class="text-right">
                                            <form class="w-100" method="GET" action="{{ url($prefix . 'search?') }}"
                                                role="search">
                                                <div class="input-group">
                                                    <input type="text" class="form-control bg-light border-0 small"
                                                        placeholder="Search for..." aria-label="Search"
                                                        aria-describedby="basic-addon2" name="search">
                                                    <div class="input-group-append">
                                                        <button type="submit" class="btn btn-primary" type="button">
                                                            <i class="fas fa-search fa-sm"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                            </form>
                                        </div>
                                        <table class="table table-borderd text-dark text-center small">
                                            <thead class="text-uppercase small text-dark">
                                                <tr>
                                                    <th>#id</th>
                                                    <th>name</th>
                                                    <th>message</th>
                                                    <th>options</th>
                                                    <th>action</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                @foreach ($data as $item)
                                                    <tr>
                                                        <td>{{ $item->id }}</td>
                                                        <td>{{ $item->name }}</td>
                                                        <td>{{ $item->message }}</td>
                                                        <td>
                                                            @foreach ($item->options as $item2)
                                                                <span>{{ $item2['keyword'] }}</span>
                                                                :<span>{{ $item2['text'] }}</span>
                                                                <br>
                                                            @endforeach
                                                        </td>
                                                        <td>
                                                            <div class="nav-item dropdown no-arrow">
                                                                <a class="dropdown-toggle" href="#"
                                                                    id="navbarDropdown" role="button"
                                                                    data-toggle="dropdown" aria-haspopup="true"
                                                                    aria-expanded="false">
                                                                    <svg xmlns="http://www.w3.org/2000/svg" width="16"
                                                                        height="16" fill="currentColor"
                                                                        class="bi bi-three-dots-vertical"
                                                                        viewBox="0 0 16 16">
                                                                        <path
                                                                            d="M9.5 13a1.5 1.5 0 1 1-3 0 1.5 1.5 0 0 1 3 0zm0-5a1.5 1.5 0 1 1-3 0 1.5 1.5 0 0 1 3 0zm0-5a1.5 1.5 0 1 1-3 0 1.5 1.5 0 0 1 3 0z" />
                                                                    </svg>
                                                                </a>

                                                                <div class="dropdown-menu dropdown-menu-right shadow animated--fade-in"
                                                                    aria-labelledby="navbarDropdown">

                                                                    <a class="dropdown-item"
                                                                        href="{{ url($prefix . 'edit?id=' . $item->id) }}">
                                                                        <svg xmlns="http://www.w3.org/2000/svg"
                                                                            width="16" height="16"
                                                                            fill="currentColor"
                                                                            class="bi bi-pencil-square"
                                                                            viewBox="0 0 16 16">
                                                                            <path
                                                                                d="M15.502 1.94a.5.5 0 0 1 0 .706L14.459 3.69l-2-2L13.502.646a.5.5 0 0 1 .707 0l1.293 1.293zm-1.75 2.456-2-2L4.939 9.21a.5.5 0 0 0-.121.196l-.805 2.414a.25.25 0 0 0 .316.316l2.414-.805a.5.5 0 0 0 .196-.12l6.813-6.814z" />
                                                                            <path fill-rule="evenodd"
                                                                                d="M1 13.5A1.5 1.5 0 0 0 2.5 15h11a1.5 1.5 0 0 0 1.5-1.5v-6a.5.5 0 0 0-1 0v6a.5.5 0 0 1-.5.5h-11a.5.5 0 0 1-.5-.5v-11a.5.5 0 0 1 .5-.5H9a.5.5 0 0 0 0-1H2.5A1.5 1.5 0 0 0 1 2.5v11z" />
                                                                        </svg>
                                                                        edit
                                                                    </a>
                                                                    <div class="dropdown-divider"></div>
                                                                    <a class="dropdown-item delete" href="#"
                                                                        id="{{ url($prefix . 'delete?id=' . $item->id) }}">
                                                                        <svg xmlns="http://www.w3.org/2000/svg"
                                                                            width="16" height="16"
                                                                            fill="currentColor" class="bi bi-trash"
                                                                            viewBox="0 0 16 16">
                                                                            <path
                                                                                d="M5.5 5.5A.5.5 0 0 1 6 6v6a.5.5 0 0 1-1 0V6a.5.5 0 0 1 .5-.5zm2.5 0a.5.5 0 0 1 .5.5v6a.5.5 0 0 1-1 0V6a.5.5 0 0 1 .5-.5zm3 .5a.5.5 0 0 0-1 0v6a.5.5 0 0 0 1 0V6z" />
                                                                            <path fill-rule="evenodd"
                                                                                d="M14.5 3a1 1 0 0 1-1 1H13v9a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2V4h-.5a1 1 0 0 1-1-1V2a1 1 0 0 1 1-1H6a1 1 0 0 1 1-1h2a1 1 0 0 1 1 1h3.5a1 1 0 0 1 1 1v1zM4.118 4 4 4.059V13a1 1 0 0 0 1 1h6a1 1 0 0 0 1-1V4.059L11.882 4H4.118zM2.5 3V2h11v1h-11z" />
                                                                        </svg>
                                                                        delete
                                                                    </a>
                                                                </div>
                                                            </div>
                                                        </td>
                                                    </tr>
                                                @endforeach
                                            </tbody>
                                        </table>
                                        @if (!empty($data))
                                            {{ $data->links() }}
                                        @endif
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <small class="d-block text-end mt-3">

        </small>
    </div>
    </div>
@endsection

@section('scripts')
    <script>
        $(document).ready(function() {
            setInterval(() => {
                ping()
            }, 5000);
        })

        function ping() {
            var url = "{{ url('admin/whatsapp-bot/server-status') }}"
            $.ajax({
                type: "GET",
                url: url,
                dataType: "JSON",
                success: function(response) {
                    console.log(response)
                    if (response === true) {
                        $(".ring-container").show();
                        $(".ring-container-failed").hide();
                    } else {
                        $(".ring-container").hide();
                        $(".ring-container-failed").show();
                    }
                }
            })
        }
        $('#add-new-option').click(function() {
            // Append the HTML section to the option-rows div
            $('#option-rows').append(`
            <div class="option-row">
                <div class="text-right"><button type="button" class="remove-btn btn btn-danger btn-sm">Remove</button></div>
                <div class="form-group">
                    <label class="small">Option Keyword <span class="text-danger">*</span></label>
                    <input type="text" class="form-control" name="keyword[]" aria-describedby="keywordHelp" placeholder="Enter Keyword Ex: help" required>
                </div>
                <div class="form-group">
                    <label class="small">Option Message <span class="text-danger">*</span> </label>
                    <textarea name="text[]" cols="30" rows="3" class="form-control" placeholder="Enter Message (any)" required></textarea>
                    <span class="small text-muted">Short Codes : [LINK]</span>
                </div>
                
            </div>
        `);
        });
        // Remove button click event using event delegation
        $('#option-rows').on('click', '.remove-btn', function() {
            $(this).closest('.option-row').remove();
        });
    </script>
@endsection
