<!DOCTYPE html>
<html lang="en">

<head>

    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta name="description" content="">
    <meta name="author" content="">
    <meta name="_token" content="{{csrf_token()}}">
    <title>@yield('title') - {{env('APP_NAME')}}</title>
    <!-- Custom fonts for this template-->
    <link rel="shortcut icon" href="{{asset('assets/img/logo.jpg')}}" type="image/x-icon">
    <link href="{{asset('assets/vendor/fontawesome-free/css/all.min.css')}}" rel="stylesheet" type="text/css">
    <link
        href="https://fonts.googleapis.com/css?family=Nunito:200,200i,300,300i,400,400i,600,600i,700,700i,800,800i,900,900i"
        rel="stylesheet">

    <!-- Custom styles for this template-->

    <link href="{{asset('assets/css/sb-admin-2.min.css')}}" rel="stylesheet">
    <link rel="stylesheet" href="{{asset('assets/vendor/sweet-alert/sweetalert2.min.css')}}">
    <link rel="stylesheet" href="{{asset('assets/css/app.css')}}">
    <script src="{{asset('assets/vendor/jquery/jquery.min.js')}}"></script>
    <script src="{{asset('assets/js/ajax.js')}}"></script>

    @yield('links')
    <style>
        .swal2-popup {
            font-size: 0.7rem !important;
            font-family: Georgia, serif;
            background: var(--primary) !important;
            color: white !important;
        }
        .swal2-icon.swal2-warning {
            border-color: var(--red) !important;
            color: var(--red) !important;
        }
    </style>
    @yield('styles')

</head>
    @include('components.common')
    

<body id="page-top">
    <div class="overlay" style="display:none;" id="loader">
        <div class="overlay__inner">
            <div class="overlay__content"><span class="spinner"></span></div>
        </div>
    </div>
    <!-- Page Wrapper -->
    <div id="wrapper">
    @include('components.sidebar')
    <!-- Content Wrapper -->
    <div id="content-wrapper" class="d-flex flex-column">
    <!-- Main Content -->
    <div id="content">
    
    @include('components.topbar')
    @php
        $subscription_need = need_subscription_within_48_hours()
    @endphp
    @if ($subscription_need)
    <div class="container alert-container">
        <div class="alert alert-warning alert-dismissible fade show" role="alert">
            <strong>Subscription expired within {{$subscription_need['hours']}} hours!</strong> Please renew your subscription to avoid any interruptions.
            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                <span aria-hidden="true">&times;</span>
            </button>
        </div>
    </div>
    @endif
    @yield('content')
    
    
    @include('components.footer')
    </div>
    
    </div>
    <!-- End of Content Wrapper -->
    
    </div>
    <!-- End of Page Wrapper -->
    
    <!-- Scroll to Top Button-->
    <a class="scroll-to-top rounded" href="#page-top">
    <i class="fas fa-angle-up"></i>
    </a>
    
    <!-- Logout Modal-->
    <div class="modal fade" id="logoutModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
    aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel">Ready to Leave?</h5>
                <button class="close" type="button" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">×</span>
                </button>
            </div>
            <div class="modal-body">Select "Logout" below if you are ready to end your current session.</div>
            <div class="modal-footer">
                <button class="btn btn-secondary" type="button" data-dismiss="modal">Cancel</button>
                <a class="btn btn-primary" href="{{url('admin/signout')}}">Logout</a>
            </div>
        </div>
    </div>
    </div>
    <!-- Bootstrap core JavaScript-->
    <script src="{{asset('assets/vendor/bootstrap/js/bootstrap.bundle.min.js')}}"></script>

    <!-- Core plugin JavaScript-->
    <script src="{{asset('assets/vendor/jquery-easing/jquery.easing.min.js')}}"></script>

    <!-- Custom scripts for all pages-->
    <script src="{{asset('assets/js/sb-admin-2.js')}}"></script>

    <!-- Page level plugins -->
    <script src="{{asset('assets/vendor/chart.js/Chart.min.js')}}"></script>

    <script src="{{asset('assets/vendor/sweet-alert/sweetalert2.all.js')}}"></script>
    <!-- Page level custom scripts -->
    {{-- <script src="js/demo/chart-area-demo.js"></script>
    <script src="js/demo/chart-pie-demo.js"></script> --}}
    <script>
        $(document).ready(function(){
            $(".validate-number-btn-multiple").click(function(){
                $('#number-validation-result').html('')
                $("#loader").show();
                var url = "{{ url('admin/common/validate-phone') }}"
                var numbers = $('.validate-number').val()
                numbers = numbers.split(',')
                numbers.forEach(number => {
                    var nb = number.replace(/\s/g, '')
                    $.ajaxSetup({
                        headers: {
                            'X-CSRF-TOKEN': $('meta[name="_token"]').attr('content')
                        }
                    });
                    $.ajax({
                    type: "POST",
                    url: url,
                    data:{
                        number:nb
                    },
                    dataType: "JSON",
                    success: function (response) {
                        $("#loader").hide();
                        if(response.data.status == "success"){
                            if(response.data.phone_valid){
                                $('#number-validation-result').append("<div class='row bg-success text-white small'>"+
                                "<div class='col-sm-3 text-center'>Validated</div>"+
                                "<div class='col-sm-3 text-center'>"+response.data.phone_region+"</div>"+
                                "<div class='col-sm-3 text-center'>"+response.data.carrier+"</div>"+
                                "<div class='col-sm-3 text-center'>"+nb+"</div>"+
                                "</div>"
                                )
                            }else{
                                $('#number-validation-result').append("<div class='row bg-danger text-white small'>"+
                                "<div class='col-sm-3 text-center'>Not Valid</div>"+
                                "<div class='col-sm-3 text-center'>"+response.data.phone_region+"</div>"+
                                "<div class='col-sm-3 text-center'>"+nb+"</div>"+
                                "</div>"
                                )
                            }
                        }else{
                            $('#number-validation-result').html(response.data.status)
                        }
                        
                    }})
                });
                
            })
            // $(".validate-number-btn").click(function(){
            //     var url = "{{ url('admin/common/validate-phone') }}"
            //     var number = $('.validate-number').val()

            //     $.ajax({
            //         type: "POST",
            //         url: url,
            //         data:{
            //             number
            //         },
            //         dataType: "JSON",
            //     success: function (response) {
            //         console.log(response)
            //         $('.validate-number').after("<div>"+response+"</div>")
            //     }})
            // })
        })
    </script>
    @yield('scripts')   
</body>

</html>