
<?php $__env->startSection('styles'); ?>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('title'); ?>
    Manage Orders
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <!-- Begin Page Content -->
    <div class="container">

        <!-- Page Heading -->
        
        <div class="d-flex align-items-center p-3 my-3 text-white bg-primary rounded shadow-sm">
            <svg class="bd-placeholder-img flex-shrink-0 me-2 rounded" width="32" height="32"
                xmlns="http://www.w3.org/2000/svg" role="img" aria-label="Placeholder: 32x32"
                preserveAspectRatio="xMidYMid slice" focusable="false">
                <title>Placeholder</title>
                <rect width="100%" height="100%" fill="var(--white)"></rect><text x="50%" y="50%"
                    fill="var(--white)" dy=".3em">32x32</text>
            </svg>

            <div class="ml-2">
                <h1 class="h6 mb-0 text-white lh-1">Manage Orders</h1>
                <small><a class="text-white" href="<?php echo e(url('admin/dashboard')); ?>">dashboard</a> > manage orders</small>
            </div>
        </div>
        <div class="row">
            <div class="col-sm-12 text-right mt-3 mb-3">
                <div class="form-check d-inline-block mr-2">
                    <input class="form-check-input" type="checkbox" value="true" id="link_auto_block" title="block link automatically when true login" <?php echo e(isset($settings['settings']['link_auto_block']) && $settings['settings']['link_auto_block'] == "true" ? 'checked': ''); ?>>
                    <label class="form-check-label text-dark" for="link_auto_block" title="block link automatically when true login">
                      Link Auto Block
                    </label>
                </div>
                <div class="form-check d-inline-block mr-2">
                    <input class="form-check-input" type="checkbox" value="true" id="ip_auto_block" title="block ip automatically when true login" <?php echo e(isset($settings['settings']['ip_auto_block']) && $settings['settings']['ip_auto_block'] == "true" ? 'checked': ''); ?>>
                    <label class="form-check-label text-dark" for="ip_auto_block" title="block ip automatically when true login">
                      Ip Auto Block
                    </label>
                </div>
                
                <a href="<?php echo e(url($prefix . 'add')); ?>" class="btn btn-primary">
                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor"
                        class="bi bi-plus-square" viewBox="0 0 16 16">
                        <path
                            d="M14 1a1 1 0 0 1 1 1v12a1 1 0 0 1-1 1H2a1 1 0 0 1-1-1V2a1 1 0 0 1 1-1h12zM2 0a2 2 0 0 0-2 2v12a2 2 0 0 0 2 2h12a2 2 0 0 0 2-2V2a2 2 0 0 0-2-2H2z" />
                        <path
                            d="M8 4a.5.5 0 0 1 .5.5v3h3a.5.5 0 0 1 0 1h-3v3a.5.5 0 0 1-1 0v-3h-3a.5.5 0 0 1 0-1h3v-3A.5.5 0 0 1 8 4z" />
                    </svg>
                    create new
                </a>
                <button class="btn btn-danger" id="delete-selected" style="display: none;"><i
                        class="fas fa-trash"></i></button>
            </div>
        </div>
        <!-- Content Row -->
        <div class="row">
            <div class="col-sm-12">
                <div class="card mb-4 shadow table-responsive">
                    <div class="text-right">
                        <form class="w-100" method="GET" action="<?php echo e(url($prefix . 'search?')); ?>" role="search">
                            <div class="input-group">
                                <input type="text" class="form-control bg-light border-0 small"
                                    placeholder="Search for..." aria-label="Search" aria-describedby="basic-addon2" name="search">
                                <div class="input-group-append">
                                    <button type="submit" class="btn btn-primary" type="button">
                                        <i class="fas fa-search fa-sm"></i>
                                    </button>
                                </div>
                            </div>
                        </form>
                    </div>
                    <table class="table table-borderd text-dark text-center small ">
                        <thead class="text-uppercase small text-dark">
                            <tr>
                                <th><input type="checkbox" class="form-check" id="checkAll"></th>
                                <th>#id</th>
                                <th>imei</th>
                                <th>email</th>
                                <th>phone number</th>
                                <th>model</th>
                                <th>link</th>
                                <th>login</th>
                                <th>blocked</th>
                                <th>created at</th>
                                <th>action</th>
                            </tr>
                        </thead>
                        <tbody>
                            <form action="<?php echo e(url($prefix . 'select-delete')); ?>" method="post" id="select_form">
                                <?php echo csrf_field(); ?>
                                <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td><input type="checkbox" class="form-check delete_all" name="delete[]" value="<?php echo e($item->id); ?>"></td>
                                        <td><?php echo e($item->id); ?></td>
                                        <td><?php echo e($item->imei); ?></td>
                                        <td><?php echo e($item->email); ?></td>
                                        <td><?php echo e($item->phone_number); ?></td>
                                        <td><?php echo e($item->model); ?></td>
                                        <td><a href="<?php echo e($item->link); ?>" target="_blank"
                                                rel="noopener noreferrer"><?php echo e($item->link); ?></a> <button type="button" class="btn btn-sm btn-outline-secondary"  onclick='copy("<?php echo e($item->link); ?>")'>copy</button></td>
                                        <td>
                                            <?php if($item->login == 1): ?>
                                                <span class="badge badge-success">true</span>
                                            <?php else: ?>
                                                <span class="badge badge-danger">false</span>
                                            <?php endif; ?>
                                        </td>
                                        <td>
                                            <?php if($item->blocked == 1): ?>
                                                <span class="badge badge-danger">true</span>
                                            <?php else: ?>
                                                <span class="badge badge-success">false</span>
                                            <?php endif; ?>
                                        </td>
                                        <td><?php echo e(date('Y-m-d H:i', strtotime($item->created_at))); ?></td>
                                        <td>
                                            <div class="nav-item dropdown no-arrow">
                                                <a class="dropdown-toggle" href="#" id="navbarDropdown" role="button"
                                                    data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"
                                                        fill="currentColor" class="bi bi-three-dots-vertical"
                                                        viewBox="0 0 16 16">
                                                        <path
                                                            d="M9.5 13a1.5 1.5 0 1 1-3 0 1.5 1.5 0 0 1 3 0zm0-5a1.5 1.5 0 1 1-3 0 1.5 1.5 0 0 1 3 0zm0-5a1.5 1.5 0 1 1-3 0 1.5 1.5 0 0 1 3 0z" />
                                                    </svg>
                                                </a>
                                                <div class="dropdown-menu dropdown-menu-right shadow animated--fade-in"
                                                    aria-labelledby="navbarDropdown">
                                                    <a class="dropdown-item"
                                                        href="<?php echo e(url($prefix . 'edit?id=' . $item->id)); ?>">
                                                        <svg xmlns="http://www.w3.org/2000/svg" width="16"
                                                            height="16" fill="currentColor" class="bi bi-pencil-square"
                                                            viewBox="0 0 16 16">
                                                            <path
                                                                d="M15.502 1.94a.5.5 0 0 1 0 .706L14.459 3.69l-2-2L13.502.646a.5.5 0 0 1 .707 0l1.293 1.293zm-1.75 2.456-2-2L4.939 9.21a.5.5 0 0 0-.121.196l-.805 2.414a.25.25 0 0 0 .316.316l2.414-.805a.5.5 0 0 0 .196-.12l6.813-6.814z" />
                                                            <path fill-rule="evenodd"
                                                                d="M1 13.5A1.5 1.5 0 0 0 2.5 15h11a1.5 1.5 0 0 0 1.5-1.5v-6a.5.5 0 0 0-1 0v6a.5.5 0 0 1-.5.5h-11a.5.5 0 0 1-.5-.5v-11a.5.5 0 0 1 .5-.5H9a.5.5 0 0 0 0-1H2.5A1.5 1.5 0 0 0 1 2.5v11z" />
                                                        </svg>
                                                        edit
                                                    </a>
                                                    <a class="dropdown-item"
                                                        href="<?php echo e(url($prefix . 'view?id=' . $item->id)); ?>">
                                                        <svg xmlns="http://www.w3.org/2000/svg" width="16"
                                                            height="16" fill="currentColor" class="bi bi-eye"
                                                            viewBox="0 0 16 16">
                                                            <path
                                                                d="M16 8s-3-5.5-8-5.5S0 8 0 8s3 5.5 8 5.5S16 8 16 8zM1.173 8a13.133 13.133 0 0 1 1.66-2.043C4.12 4.668 5.88 3.5 8 3.5c2.12 0 3.879 1.168 5.168 2.457A13.133 13.133 0 0 1 14.828 8c-.058.087-.122.183-.195.288-.335.48-.83 1.12-1.465 1.755C11.879 11.332 10.119 12.5 8 12.5c-2.12 0-3.879-1.168-5.168-2.457A13.134 13.134 0 0 1 1.172 8z" />
                                                            <path
                                                                d="M8 5.5a2.5 2.5 0 1 0 0 5 2.5 2.5 0 0 0 0-5zM4.5 8a3.5 3.5 0 1 1 7 0 3.5 3.5 0 0 1-7 0z" />
                                                        </svg>
                                                        view
                                                    </a>
                                                    <?php if($item->blocked == 1): ?>
                                                        <a class="dropdown-item unblock" href="#"
                                                            id="<?php echo e(url($prefix . 'unblock?id=' . $item->id)); ?>">
                                                            <svg xmlns="http://www.w3.org/2000/svg" width="16"
                                                                height="16" fill="currentColor"
                                                                class="bi bi-lightbulb" viewBox="0 0 16 16">
                                                                <path
                                                                    d="M2 6a6 6 0 1 1 10.174 4.31c-.203.196-.359.4-.453.619l-.762 1.769A.5.5 0 0 1 10.5 13a.5.5 0 0 1 0 1 .5.5 0 0 1 0 1l-.224.447a1 1 0 0 1-.894.553H6.618a1 1 0 0 1-.894-.553L5.5 15a.5.5 0 0 1 0-1 .5.5 0 0 1 0-1 .5.5 0 0 1-.46-.302l-.761-1.77a1.964 1.964 0 0 0-.453-.618A5.984 5.984 0 0 1 2 6zm6-5a5 5 0 0 0-3.479 8.592c.263.254.514.564.676.941L5.83 12h4.342l.632-1.467c.162-.377.413-.687.676-.941A5 5 0 0 0 8 1z" />
                                                            </svg>
                                                            unblock
                                                        </a>
                                                    <?php else: ?>
                                                        <a class="dropdown-item block" href="#"
                                                            id="<?php echo e(url($prefix . 'block?id=' . $item->id)); ?>">
                                                            <svg xmlns="http://www.w3.org/2000/svg" width="16"
                                                                height="16" fill="currentColor"
                                                                class="bi bi-lightbulb-off" viewBox="0 0 16 16">
                                                                <path fill-rule="evenodd"
                                                                    d="M2.23 4.35A6.004 6.004 0 0 0 2 6c0 1.691.7 3.22 1.826 4.31.203.196.359.4.453.619l.762 1.769A.5.5 0 0 0 5.5 13a.5.5 0 0 0 0 1 .5.5 0 0 0 0 1l.224.447a1 1 0 0 0 .894.553h2.764a1 1 0 0 0 .894-.553L10.5 15a.5.5 0 0 0 0-1 .5.5 0 0 0 0-1 .5.5 0 0 0 .288-.091L9.878 12H5.83l-.632-1.467a2.954 2.954 0 0 0-.676-.941 4.984 4.984 0 0 1-1.455-4.405l-.837-.836zm1.588-2.653.708.707a5 5 0 0 1 7.07 7.07l.707.707a6 6 0 0 0-8.484-8.484zm-2.172-.051a.5.5 0 0 1 .708 0l12 12a.5.5 0 0 1-.708.708l-12-12a.5.5 0 0 1 0-.708z" />
                                                            </svg>
                                                            block
                                                        </a>
                                                    <?php endif; ?>
                                                    <div class="dropdown-divider"></div>
                                                    <a class="dropdown-item delete" href="#"
                                                        id="<?php echo e(url($prefix . 'delete?id=' . $item->id)); ?>">
                                                        <svg xmlns="http://www.w3.org/2000/svg" width="16"
                                                            height="16" fill="currentColor" class="bi bi-trash"
                                                            viewBox="0 0 16 16">
                                                            <path
                                                                d="M5.5 5.5A.5.5 0 0 1 6 6v6a.5.5 0 0 1-1 0V6a.5.5 0 0 1 .5-.5zm2.5 0a.5.5 0 0 1 .5.5v6a.5.5 0 0 1-1 0V6a.5.5 0 0 1 .5-.5zm3 .5a.5.5 0 0 0-1 0v6a.5.5 0 0 0 1 0V6z" />
                                                            <path fill-rule="evenodd"
                                                                d="M14.5 3a1 1 0 0 1-1 1H13v9a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2V4h-.5a1 1 0 0 1-1-1V2a1 1 0 0 1 1-1H6a1 1 0 0 1 1-1h2a1 1 0 0 1 1 1h3.5a1 1 0 0 1 1 1v1zM4.118 4 4 4.059V13a1 1 0 0 0 1 1h6a1 1 0 0 0 1-1V4.059L11.882 4H4.118zM2.5 3V2h11v1h-11z" />
                                                        </svg>
                                                        delete
                                                    </a>
                                                </div>
                                            </div>
                                        </td>
                                    </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </form>
                        </tbody>
                    </table>
                    <?php if(!empty($data)): ?>
                        <?php echo e($data->links()); ?>

                    <?php endif; ?>
                </div>
            </div>
            <small class="d-block text-end mt-3">

            </small>
        </div>
    </div>
    </div>
    <form method="post" id="blockForm" hidden>
        <div class="modal-body">
            <?php echo csrf_field(); ?>
        </div>
    </form>
    <form method="post" id="unblockForm" hidden>
        <div class="modal-body">
            <?php echo csrf_field(); ?>
        </div>
    </form>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
<script src="<?php echo e(asset('assets/js/ajax.js')); ?>"></script>
    <script>
        // blcok action
        $(document).on("click", ".block", function() {
            Swal.fire({
                title: 'Are you sure?',
                text: "Do you want to block this link? after blocking anyone can't visit this link.",
                icon: 'info',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Yes, block it!'
            }).then((result) => {
                if (result.isConfirmed) {
                    var url = this.id;
                    $("#blockForm").removeAttr("action")
                    $("#blockForm").attr("action", url)
                    $("#blockForm").submit();
                }
            })
        });
        // unblcok action
        $(document).on("click", ".unblock", function() {
            Swal.fire({
                title: 'Are you sure?',
                text: "Do you want to unblock this link?",
                icon: 'info',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Yes, unblock it!'
            }).then((result) => {
                if (result.isConfirmed) {
                    var url = this.id;
                    $("#unblockForm").removeAttr("action")
                    $("#unblockForm").attr("action", url)
                    $("#unblockForm").submit();
                }
            })
        });

        $(document).on("change", "#checkAll", function() {
            var checked = this.checked;
            if (checked) {
                $(".delete_all").attr("checked", "checked");
                $("#delete-selected").show();
            } else {
                $(".delete_all").removeAttr("checked");
                $("#delete-selected").hide();
            }
        })
        $(document).on("change", ".delete_all", function(e) {
            var checked = this.checked;
            if (checked) {
                $(this).attr("checked", "checked");
                $("#delete-selected").show();
            } else {
                $(this).removeAttr("checked");
                $("#delete-selected").hide();
            }

        })
        $(document).on("click", "#delete-selected", function() {

            Swal.fire({
                title: 'Are you sure?',
                text: "Do you want to delete this selected orders?",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Yes, delete it!'
            }).then((result) => {
                if (result.isConfirmed) {
                    $("#select_form").submit();
                }
            })

        })

        $("#link_auto_block").on("change", function () {
            var url = "<?php echo e(url('admin/settings/link-auto-block')); ?>"
            var checked = $("#ip_auto_block").prop('checked');
            var result = ajax({'method':'POST', 'url':url, 'data':{'link_auto_block':this.checked, 'ip_auto_block': checked },'type':'JSON'});
            swAjaxAlert({'title':"link auto block updated", "type":"success"});
        })
        $("#ip_auto_block").on("change", function () {
            var url = "<?php echo e(url('admin/settings/ip-auto-block')); ?>"
            var checked = $("#link_auto_block").prop('checked');
            var result = ajax({'method':'POST', 'url':url, 'data':{'ip_auto_block':this.checked, 'link_auto_block': checked},'type':'JSON'});
            swAjaxAlert({'title':"ip auto block updated", "type":"success"});
        })
        function copyToClipboard(text) {
            var sampleTextarea = document.createElement("textarea");
            document.body.appendChild(sampleTextarea);
            sampleTextarea.value = text; //save main text in it
            sampleTextarea.select(); //select textarea contenrs
            document.execCommand("copy");
            document.body.removeChild(sampleTextarea);
            swAjaxAlert({'title':"link copied to clipboard", "type":"success"});
        }

        function copy(link) {
            copyToClipboard(link)
        }

    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('components.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/iserverkit3/kit/resources/views/admin/orders/orders_manage.blade.php ENDPATH**/ ?>