const fs = require('fs');

// Read JSON file
const readFile = (filePath) => {
    try {
        const fileContent = fs.readFileSync(filePath, 'utf8');
        return JSON.parse(fileContent);
    } catch (error) {
        console.error('Error reading JSON file:', error.message);
        return [];
    }
};

// Write JSON file
const writeFile = (filePath, data) => {
    try {
        fs.writeFileSync(filePath, JSON.stringify(data, null, 2), 'utf8');
        console.log('File written successfully.');
    } catch (error) {
        console.error('Error writing JSON file:', error.message);
    }
};

// Add a new session ID
const addSession = (filePath, sessionId) => {
    const sessions = readFile(filePath);
    if (!sessions.includes(sessionId)) {
        sessions.push(sessionId);
        writeFile(filePath, sessions);
    }
};

// Remove a session ID
const removeSession = (filePath, sessionId) => {
    const sessions = readFile(filePath);
    const updatedSessions = sessions.filter(id => id !== sessionId);
    const sessio_path = '.wwebjs_auth/session-' + sessionId
    writeFile(filePath, updatedSessions);
    // Delete the folder and its contents

    // delete session folder inside of .wwebjs_auth
    if (fs.existsSync(sessio_path)) {
        fs.rmdir(sessio_path, { recursive: true }, (err) => {
            if (err) {
                console.error('Error deleting session folder:', err);
            } else {
                console.log('Session data deleted successfully');
            }
        });

    }
};

// Remove a cache folder
const removeSessionCacheFolder = (session_id) => {
    const cache_path = '.wwebjs_cache'
    // delete session folder inside of .wwebjs_auth
    if (fs.existsSync(cache_path)) {
        fs.rmdir(cache_path, { recursive: true }, (err) => {
            if (err) {
                console.error('Error deleting cache folder:', err);
            } else {
                console.log('Cache Folder deleted successfully');
            }
        });

    }
};

// Remove a session folder

const removeSessionAuthFolder = (session_id) => {
    const sessio_path = '.wwebjs_auth/session-' + session_id
    // delete session folder inside of .wwebjs_auth
    if (fs.existsSync(sessio_path)) {
        fs.rmdir(sessio_path, { recursive: true }, (err) => {
            if (err) {
                console.error('Error deleting session folder:', err);
            } else {
                console.log('Session Folder deleted successfully');
            }
        });

    }
};

module.exports = {
    readFile,
    writeFile,
    addSession,
    removeSession,
    removeSessionCacheFolder,
    removeSessionAuthFolder

}