<?php

/**
 * The admin-specific functionality of the plugin.
 *
 * @link       https://onexgen.com
 * @since      1.0.0
 *
 * @package    Mpwa_Notifications
 * @subpackage Mpwa_Notifications/admin
 */

/**
 * The admin-specific functionality of the plugin.
 *
 * Defines the plugin name, version, and two examples hooks for how to
 * enqueue the admin-specific stylesheet and JavaScript.
 *
 * @package    Mpwa_Notifications
 * @subpackage Mpwa_Notifications/admin
 * @author     Magd Almuntaser <info@onexgen.com>
 */

class Mpwa_Notifications_Admin_Api{
	/**
	 * The ID of this plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      string    $mpwa_notifications    The ID of this plugin.
	 */
	private $mpwa_notifications;

	/**
	 * The version of this plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      string    $version    The current version of this plugin.
	 */
	private $version;

    private $mpwa_notif_api_url;
    private $mpwa_notif_api_headers;

	/**
	 * Initialize the class and set its properties.
	 *
	 * @since    1.0.0
	 * @param      string    $mpwa_notifications       The name of this plugin.
	 * @param      string    $version    The version of this plugin.
	 */
	public function __construct( $mpwa_notifications, $version ) {
		$this->mpwa_notifications = $mpwa_notifications;
		$this->version = $version;

        $options = get_option( 'mpwa_notifications_options' );
        $this->mpwa_notif_api_url = $options['mpwa_notifications_field_api_link'] ?? '';

        if ($options) {
            $this->mpwa_notif_api_headers = array(
                'Content-Type' => 'application/json',
                'X-SOURCE-FROM' => 'wordpress-plugin',
                'X-WP-PLUGIN-NAME' => $mpwa_notifications,
                'X-WP-PLUGIN-VERSION' => $version,
            );
        }
	}

    /**
     * Method POST for sending payload to MPWA.
     *
     * @param   string  $path from feature MPWA.
     * @param   array   $body payload.
     */
    function mpwa_post( $path, $body ) {
        $args = array(
            'body'        => wp_json_encode($body),
            'timeout'     => '5',
            'redirection' => '5',
            'httpversion' => '1.0',
            'blocking'    => true,
            'headers'     => $this->mpwa_notif_api_headers,
            'cookies'     => array(),
        );

        $response = wp_remote_post( $this->mpwa_notif_api_url . '/' . $path, $args );

        return $response;
    }
}
?>
