(function( $ ) {
	'use strict';

	/**
	 * All of the code for your admin-facing JavaScript source
	 * should reside in this file.
	 *
	 * Note: It has been assumed you will write jQuery code here, so the
	 * $ function reference has been prepared for usage within the scope
	 * of this function.
	 *
	 * This enables you to define handlers, for when the DOM is ready:
	 *
	 * $(function() {
	 *
	 * });
	 *
	 * When the window is loaded:
	 *
	 * $( window ).load(function() {
	 *
	 * });
	 *
	 * ...and/or other possibilities.
	 *
	 * Ideally, it is not considered best practise to attach more than a
	 * single DOM-ready or window-load handler for a particular page.
	 * Although scripts in the WordPress core, Plugins and Themes may be
	 * practising this, we should strive to set a better example in our own work.
	 */

    // Handle change event for checkbox
  $( window ).load(function() {
    $('.mpwa-content-status').change(function() {
      $('#mpwa_loading_overlay').css('display', 'flex')

      var template = $(this)
      var templateCode = $(this).attr('name');
      var templateStatus = $(this).is(':checked') ? 1 : 0;

      $.ajax({
        url: mpwa_ajax_obj.ajax_url,
        type: 'POST',
        data: {
            action: 'mpwa_ajax_status_action',
            nonce: mpwa_ajax_obj.nonce,
            template_status: templateStatus,
            template_code: templateCode
        },
        success: function(response) {
          if (!response.success) {
            alert(response?.data?.message || 'Failed update data !, please try again')

            if (templateStatus == 1) {
              template.prop('checked', false)
            }else{
              template.prop('checked', true)
            }
          }
          $('#mpwa_loading_overlay').css('display', 'none')
        },
        error: function(xhr, status, error) {
          alert('Failed update data !, please try again')
          $('#mpwa_loading_overlay').css('display', 'none')
        }
      });
    });
  });
})( jQuery );
