<?php

/**
 * Provide a admin area view for the plugin
 *
 * This file is used to markup the admin-facing aspects of the plugin.
 *
 * @link       https://onexgen.com
 * @since      1.0.0
 *
 * @package    Mpwa_Notifications
 * @subpackage Mpwa_Notifications/admin/partials
 */

?>

<?php
if ( ! defined( 'ABSPATH' ) ) exit;
settings_errors('mpwa_notifications_main_messages');
settings_errors('mpwa_notifications_options_messages');

if ( ! function_exists( 'is_plugin_active' ) ) {
    include_once ABSPATH . 'wp-admin/includes/plugin.php';
}
$wc_installed = file_exists( WP_PLUGIN_DIR . '/woocommerce/woocommerce.php' );
$wc_active = class_exists('WooCommerce') && ( is_plugin_active('woocommerce/woocommerce.php') || ( function_exists('is_plugin_active_for_network') && is_plugin_active_for_network('woocommerce/woocommerce.php') ) );
?>
<div class="wrap">
  <h1><?php echo esc_html( get_admin_page_title() ); ?></h1>
</div>

<div class="mpwa-options wrap" data-wc-ready="<?php echo $wc_active ? '1' : '0'; ?>">
  <?php if ( ! $wc_active ): ?>
  <div class="mpwa-alert mpwa-alert-warning">
    <button type="button" class="mpwa-clsbutton" aria-label="Close">&times;</button>
    <div class="mpwa-alert-header">WooCommerce is required</div>
    <div class="mpwa-alert-content">
      <?php if ( $wc_installed ): ?>
        <p>WooCommerce is installed but not active. Please <a href="<?php echo esc_url( admin_url('plugins.php') ); ?>">activate WooCommerce</a> to use MPWA Notifications.</p>
      <?php else: ?>
        <p>WooCommerce is not installed. Please <a href="<?php echo esc_url( admin_url('plugin-install.php?s=woocommerce&tab=search&type=term') ); ?>">install WooCommerce</a> and activate it to use MPWA Notifications.</p>
      <?php endif; ?>
    </div>
  </div>
  <?php endif; ?>

  <div class="mpwa-toolbar">
    <div class="mpwa-toolbar-left">
      <span class="dashicons dashicons-admin-generic"></span>
      <div class="mpwa-toolbar-title">Options</div>
    </div>
    <div class="mpwa-toolbar-right">
      <button type="button" id="mpwa-save-top" class="button button-primary" <?php echo $wc_active ? '' : 'disabled title="Disabled until WooCommerce is active"'; ?>>Save</button>
    </div>
  </div>

  <form action="options.php" method="post" id="mpwa-options-form">
    <?php settings_fields( 'mpwa_notifications_form_options' ); ?>
    <div class="mpwa-card <?php echo $wc_active ? '' : 'mpwa-card-disabled'; ?>">
      <div class="mpwa-card-header">
        <div class="mpwa-card-title">General Settings</div>
        <div class="mpwa-card-subtitle">Configure your MPWA Notification options</div>
      </div>
      <div class="mpwa-card-content">
        <?php do_settings_sections( 'mpwa-notifications-options' ); ?>
      </div>
      <div class="mpwa-card-footer">
        <?php submit_button( __( 'Save Settings', 'mpwa-notifications' ) ); ?>
      </div>
    </div>
  </form>

  <div class="mpwa-grid">
    <div class="mpwa-card">
      <div class="mpwa-card-header">
        <div class="mpwa-card-title">Help</div>
        <div class="mpwa-card-subtitle">Find answers and resources</div>
      </div>
      <div class="mpwa-card-content">
        <div class="mpwa-faq">
          <div class="faq-item">
            <button type="button" class="faq-q">How do I set up this plugin to work?<span class="dashicons dashicons-arrow-down-alt2"></span></button>
            <div class="faq-a">Please visit the <a href="https://www.onexgen.com/mpwa/short/plugin-wordpress-notification/" target="_blank" rel="noopener">MPWA Plugin Wordpress Notification</a> page for a complete tutorial with video instructions.</div>
          </div>
          <div class="faq-item">
            <button type="button" class="faq-q">Can I use my personal WhatsApp number as the sender?<span class="dashicons dashicons-arrow-down-alt2"></span></button>
            <div class="faq-a">Yes, you can use your personal number as the sender through the MPWA panel.</div>
          </div>
          <div class="faq-item">
            <button type="button" class="faq-q">Is this plugin free?<span class="dashicons dashicons-arrow-down-alt2"></span></button>
            <div class="faq-a">Yes, 100% free.</div>
          </div>
        </div>
      </div>
      <div class="mpwa-card-footer">
        <a class="button" href="https://onexgen.com/contact" target="_blank" rel="noopener"><span class="dashicons dashicons-sos"></span> Contact Us</a>
      </div>
    </div>

    <div class="mpwa-card">
      <div class="mpwa-card-header">
        <div class="mpwa-card-title">Support</div>
        <div class="mpwa-card-subtitle">Quick actions</div>
      </div>
      <div class="mpwa-card-content">
        <div class="mpwa-support-list">
          <div class="support-item">
            <div class="support-left">
              <span class="dashicons dashicons-email-alt"></span>
              <div>
                <div class="support-title">Email</div>
                <div class="support-sub">info@onexgen.com</div>
              </div>
            </div>
            <div class="support-right">
              <button type="button" class="button" id="mpwa-copy-email">Copy</button>
            </div>
          </div>
          <div class="support-item">
            <div class="support-left">
              <span class="dashicons dashicons-admin-site"></span>
              <div>
                <div class="support-title">Website</div>
                <div class="support-sub">onexgen.com</div>
              </div>
            </div>
            <div class="support-right">
              <a class="button" href="https://onexgen.com" target="_blank" rel="noopener">Open</a>
            </div>
          </div>
          <div class="support-item">
            <div class="support-left">
              <span class="dashicons dashicons-media-document"></span>
              <div>
                <div class="support-title">Docs</div>
                <div class="support-sub">MPWA Notification</div>
              </div>
            </div>
            <div class="support-right">
              <a class="button" href="https://www.onexgen.com/mpwa/short/plugin-wordpress-notification/" target="_blank" rel="noopener">Open</a>
            </div>
          </div>
        </div>
      </div>
      <div class="mpwa-card-footer">
        <span class="muted">Need more help? Reach out anytime.</span>
      </div>
    </div>
  </div>
</div>

<style>
.mpwa-options{--gap:16px;margin-top:10px}
.mpwa-toolbar{display:flex;align-items:center;justify-content:space-between;gap:12px;border:1px solid #e2e8f0;background:#fff;border-radius:10px;padding:12px 14px;margin-bottom:12px}
.mpwa-toolbar-left{display:flex;align-items:center;gap:8px}
.mpwa-toolbar-title{font-weight:600}
.mpwa-card{border:1px solid #e2e8f0;background:#fff;border-radius:12px;overflow:hidden;margin-bottom:12px}
.mpwa-card-header{display:flex;align-items:flex-start;justify-content:space-between;gap:8px;padding:14px 16px;border-bottom:1px solid #e2e8f0;background:#f8fafc}
.mpwa-card-title{font-weight:700}
.mpwa-card-subtitle{color:#64748b;font-size:12px}
.mpwa-card-content{padding:14px 16px}
.mpwa-card-footer{padding:12px 16px;border-top:1px solid #e2e8f0;display:flex;justify-content:flex-end;gap:8px;background:#fafafa}
.mpwa-card-disabled{opacity:.6}
.mpwa-grid{display:grid;grid-template-columns:1fr 1fr;gap:var(--gap)}
@media (max-width:1100px){.mpwa-grid{grid-template-columns:1fr}}
.form-table th{width:260px}
.form-table th,.form-table td{padding:12px 10px}
.form-table input[type="text"],.form-table input[type="password"],.form-table input[type="url"],.form-table input[type="email"],.form-table textarea,.form-table select{max-width:520px}
.muted{color:#64748b}
.mpwa-faq{display:flex;flex-direction:column;gap:8px}
.faq-item{border:1px solid #e2e8f0;border-radius:10px;overflow:hidden}
.faq-q{width:100%;text-align:left;display:flex;align-items:center;justify-content:space-between;gap:8px;padding:10px 12px;background:#fff;border:0;cursor:pointer;font-weight:600}
.faq-a{display:none;padding:10px 12px;border-top:1px solid #e2e8f0;background:#fafafa}
.faq-item.open .faq-a{display:block}
.faq-item .dashicons{transition:transform .2s}
.faq-item.open .dashicons{transform:rotate(180deg)}
.mpwa-support-list{display:flex;flex-direction:column;gap:10px}
.support-item{display:flex;align-items:center;justify-content:space-between;border:1px solid #e2e8f0;border-radius:10px;padding:10px 12px}
.support-left{display:flex;align-items:center;gap:10px}
.support-title{font-weight:600}
.support-sub{color:#64748b;font-size:12px}
.mpwa-alert{border:1px solid transparent;border-radius:10px;padding:12px 14px;margin-bottom:12px;position:relative}
.mpwa-alert .mpwa-clsbutton{position:absolute;right:10px;top:8px;background:transparent;border:0;font-size:18px;cursor:pointer;line-height:1}
.mpwa-alert-warning{background:#fffbeb;border-color:#fde68a}
.mpwa-alert-header{font-weight:700;margin-bottom:4px;color:#92400e}
.mpwa-alert-content{color:#7c2d12}
</style>

<script>
(function(){
  var form=document.getElementById('mpwa-options-form');
  var saveTop=document.getElementById('mpwa-save-top');
  var copyBtn=document.getElementById('mpwa-copy-email');
  var faqBtns=document.querySelectorAll('.faq-q');
  var wrapper=document.querySelector('.mpwa-options');
  var wcReady=wrapper&&wrapper.getAttribute('data-wc-ready')==='1';

  if(saveTop){
    saveTop.addEventListener('click',function(){
      if(!wcReady) return;
      if(form) form.requestSubmit();
    });
  }

  if(!wcReady && form){
    var inputs=form.querySelectorAll('input, select, textarea, button');
    for(var i=0;i<inputs.length;i++){ inputs[i].disabled=true; }
  }

  if(copyBtn){
    copyBtn.addEventListener('click',function(){
      var t='info@onexgen.com';
      if(navigator.clipboard&&navigator.clipboard.writeText){ navigator.clipboard.writeText(t); }
      else{
        var ta=document.createElement('textarea');
        ta.value=t; document.body.appendChild(ta); ta.select(); document.execCommand('copy'); document.body.removeChild(ta);
      }
      copyBtn.textContent='Copied';
      setTimeout(function(){ copyBtn.textContent='Copy'; },1200);
    });
  }

  if(faqBtns&&faqBtns.length){
    for(var i=0;i<faqBtns.length;i++){
      faqBtns[i].addEventListener('click',function(){
        var item=this.closest('.faq-item');
        if(item){ item.classList.toggle('open'); }
      });
    }
  }

  var closeBtns=document.querySelectorAll('.mpwa-clsbutton');
  if(closeBtns&&closeBtns.length){
    for(var j=0;j<closeBtns.length;j++){
      closeBtns[j].addEventListener('click',function(){ this.parentElement.style.display='none'; });
    }
  }
})();
</script>
