<?php if ( ! defined( 'ABSPATH' ) ) exit; ?>
<div class="mpwa-wp-sidebar">
  <div class="mpwa-wp-sidebar-title">
    <span>📜 List of Shortcodes</span>
    <input type="search" id="mpwa-sc-filter" class="mpwa-sc-search" placeholder="Filter shortcodes...">
  </div>
  <div class="mpwa-wp-sidebar-content">
    <table class="mpwa-sc-table">
      <tbody id="mpwa-sc-list">
        <?php foreach ($wc_shortcodes as $key => $shortcode): ?>
          <tr>
            <td style="width:45%">
              <a onclick="javascript:void(0)" class="mpwa-sc" data-sc="<?php echo esc_attr( $shortcode[0] ); ?>">
                <span class="mpwa-sc-badge"><?php echo esc_html( $shortcode[0] ) ?></span>
              </a>
            </td>
            <td class="mpwa-sc-desc"><?php echo esc_html( $shortcode[2] ) ?></td>
          </tr>
        <?php endforeach; ?>
      </tbody>
    </table>
  </div>
  <div class="mpwa-side-footer">Click any shortcode to insert into the editor</div>
</div>

<script>
(function(){
  var f=document.getElementById('mpwa-sc-filter');
  var list=document.getElementById('mpwa-sc-list');
  if(!f||!list) return;
  f.addEventListener('input',function(){
    var q=this.value.toLowerCase();
    var rows=list.querySelectorAll('tr');
    for(var i=0;i<rows.length;i++){
      var code=rows[i].querySelector('.mpwa-sc-badge')?.textContent.toLowerCase()||'';
      var desc=rows[i].querySelector('.mpwa-sc-desc')?.textContent.toLowerCase()||'';
      rows[i].style.display=(code.includes(q)||desc.includes(q))?'table-row':'none';
    }
  });
})();
</script>
