<?php

/**
 * The plugin bootstrap file
 *
 * This file is read by WordPress to generate the plugin information in the plugin
 * admin area. This file also includes all of the dependencies used by the plugin,
 * registers the activation and deactivation functions, and defines a function
 * that starts the plugin.
 *
 * @link              https://www.onexgen.com
 * @since             1.2.0
 * @package           mpwa_notifications
 *
 * @wordpress-plugin
 * Plugin Name:       MPWA Notifications
 * Plugin URI:        https://www.onexgen.com/mpwa/short/plugin-wordpress-notification/
 * Description:       Automatically send WhatsApp notifications for WooCommerce purchases, ensuring your customers stay updated with instant order status alerts.
 * Version:           1.2.0
 * Author:            Magd Almuntaser
 * Author URI:        https://www.onexgen.com/
 * License:           GPLv3
 * License URI:       http://www.gnu.org/licenses/gpl-3.0.html
 * Text Domain:       mpwa-notifications
 * Domain Path:       /languages
 */

// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	die;
}

if ( is_readable( __DIR__ . '/vendor/autoload.php' ) ) {
    require __DIR__ . '/vendor/autoload.php';
}

define( 'MPWA_NOTIFICATIONS_VERSION', '1.2.0' );

global $mpwa_notifications_db_version;
global $mpwa_notifications_table_name;
global $wpdb;
$mpwa_notifications_db_version = '1.0';
$mpwa_notifications_table_name = $wpdb->prefix . 'mpwa_notif_contents';

/**
 * The code that runs during plugin activation.
 * This action is documented in includes/class-mpwa-notifications-activator.php
 */
function mpwa_notifications_activate() {
	require_once plugin_dir_path( __FILE__ ) . 'includes/class-mpwa-notifications-activator.php';
	Mpwa_Notifications_Activator::activate();
}

/**
 * The code that runs during plugin deactivation.
 * This action is documented in includes/class-mpwa-notifications-deactivator.php
 */
function mpwa_notifications_deactivate() {
	require_once plugin_dir_path( __FILE__ ) . 'includes/class-mpwa-notifications-deactivator.php';
	Mpwa_Notifications_Deactivator::deactivate();
}

register_activation_hook( __FILE__, 'mpwa_notifications_activate' );
register_deactivation_hook( __FILE__, 'mpwa_notifications_deactivate' );

/**
 * The core plugin class that is used to define internationalization,
 * admin-specific hooks, and public-facing site hooks.
 */
require plugin_dir_path( __FILE__ ) . 'includes/class-mpwa-notifications.php';

/**
 * Begins execution of the plugin.
 *
 * Since everything within the plugin is registered via hooks,
 * then kicking off the plugin from this point in the file does
 * not affect the page life cycle.
 *
 * @since    1.0.0
 */
function mpwa_notifications_run() {

	$plugin = new Mpwa_Notifications();
	$plugin->run();

}
mpwa_notifications_run();
